/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.common.branch;

import java.text.MessageFormat;
import java.util.Map;
import org.eclipse.emf.cdo.common.CDOCommonRepository;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchCreatedEvent;
import org.eclipse.emf.cdo.common.branch.CDOBranchHandler;
import org.eclipse.emf.cdo.common.branch.CDOBranchManager;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.util.CDOTimeProvider;
import org.eclipse.emf.cdo.internal.common.branch.CDOBranchImpl;
import org.eclipse.emf.cdo.spi.common.branch.InternalCDOBranch;
import org.eclipse.emf.cdo.spi.common.branch.InternalCDOBranchManager;
import org.eclipse.net4j.util.collection.Pair;
import org.eclipse.net4j.util.container.Container;
import org.eclipse.net4j.util.event.Event;
import org.eclipse.net4j.util.event.INotifier;
import org.eclipse.net4j.util.ref.ReferenceValueMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CDOBranchManagerImpl
extends Container<CDOBranch>
implements InternalCDOBranchManager {
    private CDOCommonRepository repository;
    private InternalCDOBranchManager.BranchLoader branchLoader;
    private InternalCDOBranch mainBranch;
    private Map<Integer, InternalCDOBranch> branches = this.createMap();

    @Override
    public CDOCommonRepository getRepository() {
        return this.repository;
    }

    @Override
    public void setRepository(CDOCommonRepository repository) {
        this.repository = repository;
    }

    @Override
    public InternalCDOBranchManager.BranchLoader getBranchLoader() {
        return this.branchLoader;
    }

    @Override
    public void setBranchLoader(InternalCDOBranchManager.BranchLoader branchLoader) {
        this.checkInactive();
        this.branchLoader = branchLoader;
    }

    @Override
    public CDOTimeProvider getTimeProvider() {
        return this.repository;
    }

    @Override
    @Deprecated
    public void setTimeProvider(CDOTimeProvider timeProvider) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void initMainBranch(boolean local, long timeStamp) {
        this.mainBranch = new CDOBranchImpl.Main(this, local, timeStamp);
    }

    @Override
    public void handleBranchCreated(InternalCDOBranch branch) {
        CDOBranchPoint base = branch.getBase();
        InternalCDOBranch baseBranch = (InternalCDOBranch)base.getBranch();
        baseBranch.addChild(branch);
        this.fireEvent(new BranchCreatedEvent(branch));
    }

    public CDOBranch[] getElements() {
        return new CDOBranch[]{this.getMainBranch()};
    }

    @Override
    public InternalCDOBranch getMainBranch() {
        this.checkActive();
        return this.mainBranch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InternalCDOBranch getBranch(int branchID) {
        InternalCDOBranch branch;
        this.checkActive();
        if (branchID == 0) {
            return this.mainBranch;
        }
        Map<Integer, InternalCDOBranch> map = this.branches;
        synchronized (map) {
            branch = this.branches.get(branchID);
            if (branch == null) {
                branch = new CDOBranchImpl(this, branchID, null, null);
                this.putBranch(branch);
            }
        }
        return branch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InternalCDOBranch getBranch(int id, String name, InternalCDOBranch baseBranch, long baseTimeStamp) {
        Map<Integer, InternalCDOBranch> map = this.branches;
        synchronized (map) {
            InternalCDOBranch branch = this.branches.get(id);
            if (branch == null) {
                branch = new CDOBranchImpl(this, id, name, baseBranch.getPoint(baseTimeStamp));
                this.putBranch(branch);
            } else if (branch.isProxy()) {
                branch.setBranchInfo(name, baseBranch, baseTimeStamp);
            }
            return branch;
        }
    }

    @Override
    public InternalCDOBranch getBranch(int id, InternalCDOBranchManager.BranchLoader.BranchInfo branchInfo) {
        String name = branchInfo.getName();
        InternalCDOBranch baseBranch = this.getBranch(branchInfo.getBaseBranchID());
        long baseTimeStamp = branchInfo.getBaseTimeStamp();
        return this.getBranch(id, name, baseBranch, baseTimeStamp);
    }

    @Override
    public InternalCDOBranch getBranch(String path) {
        int sep;
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if ((sep = path.indexOf("/")) == -1) {
            if ("MAIN".equals(path)) {
                return this.mainBranch;
            }
            return null;
        }
        String name = path.substring(0, sep);
        if ("MAIN".equals(name)) {
            String rest = path.substring(sep + 1);
            return this.mainBranch.getBranch(rest);
        }
        return null;
    }

    @Override
    public int getBranches(int startID, int endID, CDOBranchHandler handler) {
        this.checkActive();
        return this.branchLoader.loadBranches(startID, endID, handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InternalCDOBranch createBranch(int branchID, String name, InternalCDOBranch baseBranch, long baseTimeStamp) {
        this.checkActive();
        Pair<Integer, Long> result = this.branchLoader.createBranch(branchID, new InternalCDOBranchManager.BranchLoader.BranchInfo(name, baseBranch.getID(), baseTimeStamp));
        branchID = (Integer)result.getElement1();
        baseTimeStamp = (Long)result.getElement2();
        CDOBranchPoint base = baseBranch.getPoint(baseTimeStamp);
        CDOBranchImpl branch = new CDOBranchImpl(this, branchID, name, base);
        Map<Integer, InternalCDOBranch> map = this.branches;
        synchronized (map) {
            this.putBranch(branch);
        }
        this.handleBranchCreated(branch);
        return branch;
    }

    public String toString() {
        return MessageFormat.format("BranchManager[loader={0}]", this.branchLoader);
    }

    private boolean putBranch(InternalCDOBranch branch) {
        int id = branch.getID();
        if (this.branches.containsKey(id)) {
            return false;
        }
        this.branches.put(id, branch);
        return true;
    }

    protected ReferenceValueMap.Soft<Integer, InternalCDOBranch> createMap() {
        return new ReferenceValueMap.Soft();
    }

    protected void doBeforeActivate() throws Exception {
        super.doBeforeActivate();
        this.checkState(this.repository, "repository");
        this.checkState(this.branchLoader, "branchLoader");
    }

    private static final class BranchCreatedEvent
    extends Event
    implements CDOBranchCreatedEvent {
        private static final long serialVersionUID = 1L;
        private CDOBranch branch;

        public BranchCreatedEvent(CDOBranch branch) {
            super((INotifier)branch.getBranchManager());
            this.branch = branch;
        }

        public CDOBranchManager getSource() {
            return (CDOBranchManager)super.getSource();
        }

        public CDOBranch getBranch() {
            return this.branch;
        }
    }
}

