/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.security.impl;

import org.eclipse.emf.cdo.security.Access;
import org.eclipse.emf.cdo.security.Group;
import org.eclipse.emf.cdo.security.Permission;
import org.eclipse.emf.cdo.security.Realm;
import org.eclipse.emf.cdo.security.RealmUtil;
import org.eclipse.emf.cdo.security.Role;
import org.eclipse.emf.cdo.security.SecurityItem;
import org.eclipse.emf.cdo.security.SecurityPackage;
import org.eclipse.emf.cdo.security.User;
import org.eclipse.emf.cdo.security.impl.CachedList;
import org.eclipse.emf.cdo.security.impl.SecurityElementImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RealmImpl
extends SecurityElementImpl
implements Realm {
    private EList<User> allUsers = new CachedList<User>(){

        @Override
        protected InternalEObject getOwner() {
            return RealmImpl.this;
        }

        @Override
        protected EStructuralFeature getFeature() {
            return SecurityPackage.Literals.REALM__ALL_USERS;
        }

        @Override
        protected Object[] getData() {
            EList<SecurityItem> items = RealmImpl.this.getItems();
            return RealmUtil.allUsers(items).toArray();
        }
    };
    private EList<Group> allGroups = new CachedList<Group>(){

        @Override
        protected InternalEObject getOwner() {
            return RealmImpl.this;
        }

        @Override
        protected EStructuralFeature getFeature() {
            return SecurityPackage.Literals.REALM__ALL_GROUPS;
        }

        @Override
        protected Object[] getData() {
            EList<SecurityItem> items = RealmImpl.this.getItems();
            return RealmUtil.allGroups(items).toArray();
        }
    };
    private EList<Role> allRoles = new CachedList<Role>(){

        @Override
        protected InternalEObject getOwner() {
            return RealmImpl.this;
        }

        @Override
        protected EStructuralFeature getFeature() {
            return SecurityPackage.Literals.REALM__ALL_ROLES;
        }

        @Override
        protected Object[] getData() {
            EList<SecurityItem> items = RealmImpl.this.getItems();
            return RealmUtil.allRoles(items).toArray();
        }
    };
    private EList<Permission> allPermissions = new CachedList<Permission>(){

        @Override
        protected InternalEObject getOwner() {
            return RealmImpl.this;
        }

        @Override
        protected EStructuralFeature getFeature() {
            return SecurityPackage.Literals.REALM__ALL_PERMISSIONS;
        }

        @Override
        protected Object[] getData() {
            EList<SecurityItem> items = RealmImpl.this.getItems();
            return RealmUtil.allPermissions(items).toArray();
        }
    };

    protected RealmImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return SecurityPackage.Literals.REALM;
    }

    @Override
    public EList<SecurityItem> getItems() {
        return (EList)this.eGet((EStructuralFeature)SecurityPackage.Literals.REALM__ITEMS, true);
    }

    @Override
    public EList<User> getAllUsers() {
        return this.allUsers;
    }

    @Override
    public EList<Group> getAllGroups() {
        return this.allGroups;
    }

    @Override
    public EList<Role> getAllRoles() {
        return this.allRoles;
    }

    @Override
    public EList<Permission> getAllPermissions() {
        return this.allPermissions;
    }

    @Override
    public String getName() {
        return (String)this.eGet((EStructuralFeature)SecurityPackage.Literals.REALM__NAME, true);
    }

    @Override
    public void setName(String newName) {
        this.eSet((EStructuralFeature)SecurityPackage.Literals.REALM__NAME, newName);
    }

    @Override
    public Access getDefaultAccess() {
        return (Access)((Object)this.eGet((EStructuralFeature)SecurityPackage.Literals.REALM__DEFAULT_ACCESS, true));
    }

    @Override
    public void setDefaultAccess(Access newDefaultAccess) {
        this.eSet((EStructuralFeature)SecurityPackage.Literals.REALM__DEFAULT_ACCESS, (Object)newDefaultAccess);
    }

    @Override
    public Realm getRealm() {
        return this;
    }
}

