/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.objectivity;

import org.eclipse.emf.cdo.common.revision.delta.CDOAddFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOClearFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOContainerFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOFeatureDeltaVisitor;
import org.eclipse.emf.cdo.common.revision.delta.CDOListFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOMoveFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDORemoveFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOSetFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOUnsetFeatureDelta;
import org.eclipse.emf.cdo.server.internal.objectivity.db.ObjyObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class ObjectivityFeatureDeltaWriter
implements CDOFeatureDeltaVisitor {
    private ObjyObject objyObject = null;
    private EStructuralFeature eFeature = null;

    public ObjectivityFeatureDeltaWriter(ObjyObject objyObject) {
        this.objyObject = objyObject;
    }

    public void nextFeature() {
        this.eFeature = null;
    }

    protected void fillStructuralFeature(CDOFeatureDelta delta) {
        this.eFeature = delta.getFeature();
    }

    public void visit(CDOMoveFeatureDelta delta) {
        this.fillStructuralFeature((CDOFeatureDelta)delta);
        this.objyObject.move(this.eFeature, delta.getNewPosition(), delta.getOldPosition());
    }

    public void visit(CDOAddFeatureDelta delta) {
        this.fillStructuralFeature((CDOFeatureDelta)delta);
        this.objyObject.add(this.eFeature, delta.getIndex(), delta.getValue());
    }

    public void visit(CDORemoveFeatureDelta delta) {
        this.fillStructuralFeature((CDOFeatureDelta)delta);
        this.objyObject.remove(this.eFeature, delta.getIndex());
    }

    public void visit(CDOSetFeatureDelta delta) {
        this.fillStructuralFeature((CDOFeatureDelta)delta);
        Object value = delta.getValue();
        this.objyObject.set(this.eFeature, delta.getIndex(), value);
    }

    public void visit(CDOUnsetFeatureDelta delta) {
        this.fillStructuralFeature((CDOFeatureDelta)delta);
        this.objyObject.unset(this.eFeature);
    }

    public void visit(CDOListFeatureDelta deltas) {
        for (CDOFeatureDelta delta : deltas.getListChanges()) {
            delta.accept((CDOFeatureDeltaVisitor)this);
        }
    }

    public void visit(CDOClearFeatureDelta delta) {
        this.fillStructuralFeature((CDOFeatureDelta)delta);
        this.objyObject.clear(this.eFeature);
    }

    public void visit(CDOContainerFeatureDelta delta) {
        this.objyObject.setEContainer(delta.getContainerID());
        this.objyObject.setEContainingFeature(delta.getContainerFeatureID());
        this.objyObject.setEResource(delta.getResourceID());
    }
}

