/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.objectivity.clustering;

import com.objy.db.ObjyRuntimeException;
import com.objy.db.app.ooId;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDTemp;
import org.eclipse.emf.cdo.eresource.EresourcePackage;
import org.eclipse.emf.cdo.server.internal.objectivity.ObjectivityStore;
import org.eclipse.emf.cdo.server.internal.objectivity.bundle.OM;
import org.eclipse.emf.cdo.server.internal.objectivity.db.ObjyObject;
import org.eclipse.emf.cdo.server.internal.objectivity.db.ObjyScope;
import org.eclipse.emf.cdo.server.internal.objectivity.db.ObjySession;
import org.eclipse.emf.cdo.server.internal.objectivity.utils.OBJYCDOIDUtil;
import org.eclipse.emf.cdo.spi.common.id.AbstractCDOIDLong;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.spi.server.InternalCommitContext;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.net4j.util.om.trace.ContextTracer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjyPlacementManagerLocal {
    private static final ContextTracer TRACER_DEBUG = new ContextTracer(OM.DEBUG, ObjyPlacementManagerLocal.class);
    private String repositoryName = null;
    ObjySession objySession = null;
    InternalCommitContext commitContext = null;
    Map<CDOID, InternalCDORevision> newObjectsMap;
    Map<CDOID, CDOID> idMapper;
    Map<CDOID, ObjyObject> newObjyObjectsMap;

    public ObjyPlacementManagerLocal(ObjectivityStore objyStore, ObjySession objySession, InternalCommitContext commitContext, Map<CDOID, ObjyObject> newObjyObjectsMap) {
        this.repositoryName = objyStore.getRepository().getName();
        this.objySession = objySession;
        this.commitContext = commitContext;
        this.newObjectsMap = new HashMap<CDOID, InternalCDORevision>();
        InternalCDORevision[] internalCDORevisionArray = commitContext.getNewObjects();
        int n = internalCDORevisionArray.length;
        int n2 = 0;
        while (n2 < n) {
            InternalCDORevision revision = internalCDORevisionArray[n2];
            this.newObjectsMap.put(revision.getID(), revision);
            ++n2;
        }
        this.idMapper = new HashMap<CDOID, CDOID>();
        this.newObjyObjectsMap = newObjyObjectsMap;
    }

    public void processRevision(InternalCDORevision revision) {
        if (this.isIdProcessed(revision.getID())) {
            return;
        }
        try {
            this.createObjectAndAddToMapping(revision);
        }
        catch (ObjyRuntimeException ex) {
            ex.printStackTrace();
        }
    }

    private ObjyObject createObjectAndAddToMapping(InternalCDORevision revision) {
        ObjyObject objyObject = this.createObject(revision);
        CDOID newID = OBJYCDOIDUtil.getCDOID(objyObject.ooId());
        if (TRACER_DEBUG.isEnabled()) {
            TRACER_DEBUG.trace("Adding object to mapping from " + revision.getID() + " to " + newID);
        }
        this.commitContext.addIDMapping(revision.getID(), newID);
        this.idMapper.put(revision.getID(), newID);
        this.newObjyObjectsMap.put(newID, objyObject);
        return objyObject;
    }

    protected boolean isIdProcessed(CDOID id) {
        return this.idMapper.get(id) != null;
    }

    protected ObjyObject createObject(InternalCDORevision revision) {
        long startTime = System.nanoTime();
        ooId nearObject = null;
        EClass eClass = revision.getEClass();
        if (TRACER_DEBUG.isEnabled()) {
            TRACER_DEBUG.trace("Creating new object for revision: " + revision + " - eClass: " + eClass);
        }
        if (revision.isResourceNode()) {
            String resourceName = (String)revision.data().get((EStructuralFeature)EresourcePackage.eINSTANCE.getCDOResourceNode_Name(), 0);
            if (resourceName == null) {
                nearObject = this.objySession.getResourceList(this.repositoryName).ooId();
            } else {
                ObjyScope objyScope = new ObjyScope(this.repositoryName, resourceName);
                nearObject = objyScope.getScopeContOid();
            }
        } else {
            nearObject = this.getNearObject(revision);
        }
        if (nearObject == null) {
            nearObject = this.objySession.getObjectManager().getGlobalPlacementManager().getNearObject(null, null, revision.getEClass());
        }
        ObjyObject objyObject = this.objySession.getObjectManager().newObject(eClass, nearObject);
        ObjyObject.createObjectTime += System.nanoTime() - startTime;
        ++ObjyObject.createObjectCount;
        return objyObject;
    }

    protected ooId getNearObject(InternalCDORevision revision) {
        ooId nearObject = null;
        Object id = revision.getContainerID();
        if (id instanceof CDOID && (CDOID)id != CDOID.NULL) {
            nearObject = this.getOidFromCDOID((CDOID)id);
        } else {
            CDOID resourceId = revision.getResourceID();
            nearObject = this.getOidFromCDOID(resourceId);
        }
        return nearObject;
    }

    protected ooId getOidFromCDOID(CDOID id) {
        ooId oid = null;
        if (id instanceof AbstractCDOIDLong) {
            oid = OBJYCDOIDUtil.getooId(id);
        } else if (id instanceof CDOIDTemp) {
            CDOID nearId = this.idMapper.get(id);
            if (nearId != null) {
                oid = OBJYCDOIDUtil.getooId(nearId);
            } else {
                InternalCDORevision containerRevision = this.newObjectsMap.get(id);
                if (containerRevision != null) {
                    oid = this.createObjectAndAddToMapping(containerRevision).ooId();
                }
            }
        }
        return oid;
    }
}

