/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.objectivity.db;

import com.objy.as.app.Proposed_Class;
import com.objy.as.app.d_Access_Kind;
import com.objy.as.app.d_Attribute;
import com.objy.as.app.d_Class;
import com.objy.as.app.d_Inheritance;
import com.objy.as.app.d_Module;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.emf.cdo.common.model.EMFUtil;
import org.eclipse.emf.cdo.server.internal.objectivity.bundle.OM;
import org.eclipse.emf.cdo.server.internal.objectivity.db.ObjySchema;
import org.eclipse.emf.cdo.server.internal.objectivity.mapper.ITypeMapper;
import org.eclipse.emf.cdo.server.internal.objectivity.mapper.ObjyMapper;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.net4j.util.om.trace.ContextTracer;

public class ObjyClassProposed {
    private static final ContextTracer TRACER_DEBUG = new ContextTracer(OM.DEBUG, ObjyClassProposed.class);
    private EClass eClass;
    private d_Module module;
    private boolean onlyStructure = false;

    public ObjyClassProposed(d_Module module, EClass eClass, boolean onlyStructure) {
        this.eClass = eClass;
        this.module = module;
        this.onlyStructure = onlyStructure;
    }

    public void propose() {
        String className = ObjySchema.formObjectivityClassName((EClassifier)this.eClass, this.onlyStructure);
        Proposed_Class proposedooClass = null;
        proposedooClass = ObjySchema.getTopModule().propose_new_class(className);
        if (TRACER_DEBUG.isEnabled()) {
            TRACER_DEBUG.trace("ECLASS " + this.eClass.getName() + " -> " + className + " = ADD - START");
        }
        int countIndex = 0;
        for (EClass eSuperObject : this.eClass.getESuperTypes()) {
            if (TRACER_DEBUG.isEnabled()) {
                TRACER_DEBUG.trace("ECLASS " + className + " ADDING SUPER CLASS " + eSuperObject.getName());
            }
            boolean itrOnlyStructure = countIndex == 0 ? this.onlyStructure : true;
            ObjySchema.createObjyClassSchema(eSuperObject, itrOnlyStructure);
            String superClassName = ObjySchema.formObjectivityClassName((EClassifier)eSuperObject, itrOnlyStructure);
            proposedooClass.add_base_class(-1, d_Access_Kind.d_PUBLIC, superClassName);
            ++countIndex;
        }
        if (this.eClass.getESuperTypes().size() == 0 && !this.onlyStructure) {
            proposedooClass.add_base_class(-1, d_Access_Kind.d_PUBLIC, "ObjyBase");
        }
        EList listFeatures = this.eClass.getEStructuralFeatures();
        ArrayList<EClass> toBeProcessed = new ArrayList<EClass>();
        for (EStructuralFeature feature : listFeatures) {
            if (!(feature instanceof EAttribute) && !(feature instanceof EReference) || !EMFUtil.isPersistent((EStructuralFeature)feature)) continue;
            EClassifier destination = feature.getEType();
            ITypeMapper bridge = ObjyMapper.INSTANCE.getTypeMapper(feature);
            if (bridge == null) continue;
            bridge.createSchema(proposedooClass, feature);
            if (TRACER_DEBUG.isEnabled()) {
                TRACER_DEBUG.trace("New Attribut for " + this.eClass.getName() + " name : " + feature.getName());
            }
            if (!(feature instanceof EReference)) continue;
            toBeProcessed.add((EClass)destination);
        }
        if (TRACER_DEBUG.isEnabled()) {
            TRACER_DEBUG.trace("ECLASS " + this.eClass.getName() + " -> " + className + " -- DONE");
        }
        for (EClass classifier : toBeProcessed) {
            ObjySchema.createObjyClassSchema(classifier, false);
        }
    }

    public void evolve(d_Class dClass) {
        String className = ObjySchema.formObjectivityClassName((EClassifier)this.eClass, this.onlyStructure);
        Proposed_Class proposedooClass = null;
        if (TRACER_DEBUG.isEnabled()) {
            TRACER_DEBUG.trace("ECLASS " + this.eClass.getName() + " -> " + className + " EVOLVE - START");
        }
        Iterator subClasses = dClass.sub_class_list();
        while (subClasses.hasNext()) {
            d_Inheritance subClass = (d_Inheritance)subClasses.next();
            this.module.propose_evolved_class(subClass.inherits_to().name());
        }
        proposedooClass = this.module.propose_evolved_class(className);
        EList listFeatures = this.eClass.getEStructuralFeatures();
        ArrayList<EClass> toBeEvolve = new ArrayList<EClass>();
        for (EStructuralFeature feature : listFeatures) {
            if (!(feature instanceof EAttribute) && !(feature instanceof EReference) || !EMFUtil.isPersistent((EStructuralFeature)feature)) continue;
            EClassifier destination = feature.getEType();
            ITypeMapper bridge = ObjyMapper.INSTANCE.getTypeMapper(feature);
            if (bridge == null) continue;
            d_Attribute attr = null;
            attr = dClass.resolve_attribute(feature.getName());
            if (attr == null) {
                if (TRACER_DEBUG.isEnabled()) {
                    TRACER_DEBUG.trace("New Attribut for " + this.eClass.getName() + " name : " + feature.getName());
                }
                bridge.createSchema(proposedooClass, feature);
            } else if (TRACER_DEBUG.isEnabled()) {
                TRACER_DEBUG.trace("Attribut Changed for " + this.eClass.getName() + " name : " + feature.getName());
                TRACER_DEBUG.trace("... attribute change is not supported in this release... for " + this.eClass.getName() + " name : " + feature.getName());
            }
            if (!(feature instanceof EReference)) continue;
            toBeEvolve.add((EClass)destination);
        }
        TRACER_DEBUG.trace("evolve ECLASS " + this.eClass.getName() + " -> " + className + " -- DONE");
        for (EClass classifier : toBeEvolve) {
            String localName = ObjySchema.formObjectivityClassName((EClassifier)classifier, false);
            d_Class localDClass = ObjySchema.getTopModule().resolve_class(localName);
            if (localDClass == null) {
                ObjySchema.createObjyClassSchema(classifier, false);
                continue;
            }
            ObjySchema.evolveObjyClassSchema(classifier, false);
        }
    }
}

