/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.objectivity.db;

import com.objy.db.CannotUpgradeLockException;
import com.objy.db.app.Session;
import com.objy.db.app.ooContObj;
import com.objy.db.app.ooId;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.emf.cdo.server.internal.objectivity.bundle.OM;
import org.eclipse.emf.cdo.server.internal.objectivity.db.ObjyConnection;
import org.eclipse.emf.cdo.server.internal.objectivity.db.ObjyObjectManager;
import org.eclipse.emf.cdo.server.internal.objectivity.schema.ObjyBranchManager;
import org.eclipse.emf.cdo.server.internal.objectivity.schema.ObjyLockAreaManager;
import org.eclipse.emf.cdo.server.internal.objectivity.schema.ObjyResourceList;
import org.eclipse.emf.cdo.server.internal.objectivity.utils.ObjyDb;
import org.eclipse.net4j.util.om.trace.ContextTracer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjySession
extends Session {
    private static final ContextTracer TRACER_INFO = new ContextTracer(OM.INFO, ObjySession.class);
    private ObjyObjectManager objectManger = null;
    private ObjyResourceList resourceList = null;
    private ObjyBranchManager branchManager = null;
    private ObjyLockAreaManager lockAreaManager = null;
    protected String sessionName;
    protected ConcurrentHashMap<String, ObjySession> sessionPool;
    protected boolean available;

    public ObjySession(String name, ConcurrentHashMap<String, ObjySession> pool, ObjyConnection objyConnection) {
        super(objyConnection.getMinSessionCacheSize(), objyConnection.getMaxSessionCacheSize());
        this.setThreadPolicy(1);
        this.setIndexMode(3);
        this.sessionName = name;
        this.sessionPool = pool;
        this.objectManger = new ObjyObjectManager(objyConnection.getDefaultPlacementManager());
    }

    public ObjyObjectManager getObjectManager() {
        return this.objectManger;
    }

    public ObjyBranchManager getBranchManager(String repositoryName) {
        if (this.branchManager == null) {
            this.branchManager = ObjyDb.getOrCreateBranchManager(repositoryName);
        }
        return this.branchManager;
    }

    public ObjyLockAreaManager getLockAreaManager(String repositoryName) {
        if (this.lockAreaManager == null) {
            this.lockAreaManager = ObjyDb.getOrCreateLockAreaManager(repositoryName);
        }
        return this.lockAreaManager;
    }

    public void setAvailable(boolean value) {
        this.available = value;
    }

    public boolean isAvailable() {
        return this.available;
    }

    public String getName() {
        return this.sessionName;
    }

    public void setName(String name) {
        this.sessionName = name;
    }

    public ConcurrentHashMap<String, ObjySession> getPool() {
        return this.sessionPool;
    }

    public ObjyResourceList getResourceList(String repositoryName) {
        if (this.resourceList == null) {
            this.resourceList = new ObjyResourceList(this, ObjyDb.getOrCreateResourceList(repositoryName));
        }
        return this.resourceList;
    }

    public synchronized void returnSessionToPool() {
        this.leave();
        this.setAvailable(true);
    }

    public synchronized void terminate() {
        this.resourceList = null;
        super.terminate();
    }

    /*
     * Unable to fully structure code
     */
    public void lockContainers(Set<ooId> containerToLocks) {
        if (!containerToLocks.isEmpty()) {
            idsToLock = containerToLocks.toArray(new ooId[containerToLocks.size()]);
            count = 10;
            block5: while (count-- != 0) {
                try {
                    this.openContainers(idsToLock, 2);
                    break;
                }
                catch (CannotUpgradeLockException cule) {
                    var8_11 = idsToLock;
                    var7_10 = idsToLock.length;
                    var6_9 = 0;
                    ** while (var6_9 < var7_10)
                }
lbl-1000:
                // 1 sources

                {
                    contId = var8_11[var6_9];
                    contObj = (ooContObj)this.getFD().objectFrom(contId);
                    contObj.refresh(11);
                    ++var6_9;
                    continue;
lbl18:
                    // 1 sources

                    continue block5;
                }
                catch (Exception e) {
                    ObjySession.TRACER_INFO.trace("Locking problem try again : " + e.getMessage());
                    if (!this.isOpen()) {
                        ObjySession.TRACER_INFO.trace("Objy session is not open");
                    }
                    try {
                        this.wait(500L);
                    }
                    catch (InterruptedException var5_8) {
                        // empty catch block
                    }
                }
            }
        }
    }
}

