/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.objectivity.schema;

import com.objy.db.app.ooId;
import com.objy.db.app.ooObj;
import com.objy.db.util.ooTreeSetX;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.lock.IDurableLockingManager;
import org.eclipse.emf.cdo.server.internal.objectivity.schema.ObjyBranch;
import org.eclipse.emf.cdo.server.internal.objectivity.utils.OBJYCDOIDUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjyLockArea
extends ooObj {
    public static final int DEFAULT_DURABLE_LOCKING_ID_BYTES = 32;
    private String durableLockingID;
    private String userID;
    private ObjyBranch branchPoint;
    private boolean readOnly;
    private ooTreeSetX readLockSet;
    private ooTreeSetX writeLockSet;
    private ooTreeSetX readWriteLockSet;

    protected ObjyLockArea(String durableLockingID, String userID, ObjyBranch branchPoint, boolean readOnly) {
        this.durableLockingID = durableLockingID;
        this.userID = userID;
        this.branchPoint = branchPoint;
        this.readOnly = readOnly;
    }

    public static ObjyLockArea create(ooId scopeContOid, String durableLockingID, String userID, ObjyBranch branchPoint, boolean readOnly, Map<CDOID, IDurableLockingManager.LockGrade> locks) {
        ObjyLockArea objyLockArea = new ObjyLockArea(durableLockingID, userID, branchPoint, readOnly);
        ooObj clusterObject = ooObj.create_ooObj((ooId)scopeContOid);
        clusterObject.cluster((Object)objyLockArea);
        objyLockArea.createLockSets(locks);
        return objyLockArea;
    }

    protected void createLockSets(Map<CDOID, IDurableLockingManager.LockGrade> locks) {
        this.readLockSet = new ooTreeSetX();
        this.cluster(this.readLockSet);
        this.writeLockSet = new ooTreeSetX();
        this.cluster(this.writeLockSet);
        this.readWriteLockSet = new ooTreeSetX();
        this.cluster(this.readWriteLockSet);
        for (Map.Entry<CDOID, IDurableLockingManager.LockGrade> entry : locks.entrySet()) {
            CDOID id = entry.getKey();
            IDurableLockingManager.LockGrade grade = entry.getValue();
            switch (grade) {
                case READ_WRITE: {
                    this.readWriteLockSet.add((Object)id);
                    break;
                }
                case READ: {
                    this.readLockSet.add((Object)id);
                    break;
                }
                case WRITE: {
                    this.writeLockSet.add((Object)id);
                }
            }
        }
    }

    public String getDurableLockingID() {
        this.fetch();
        return this.durableLockingID;
    }

    public String getUserID() {
        this.fetch();
        return this.userID;
    }

    public ObjyBranch getBranch() {
        this.fetch();
        return this.branchPoint;
    }

    public long getTimeStamp() {
        this.fetch();
        return this.branchPoint.getBranchInfo().getBaseTimeStamp();
    }

    public boolean isReadOnly() {
        this.fetch();
        return this.readOnly;
    }

    public Map<CDOID, IDurableLockingManager.LockGrade> getLocks() {
        this.fetch();
        HashMap<CDOID, IDurableLockingManager.LockGrade> locks = new HashMap<CDOID, IDurableLockingManager.LockGrade>();
        Iterator itr = this.readLockSet.iterator();
        while (itr.hasNext()) {
            locks.put(OBJYCDOIDUtil.getCDOID(((ooObj)itr.next()).getOid()), IDurableLockingManager.LockGrade.READ);
        }
        itr = this.writeLockSet.iterator();
        while (itr.hasNext()) {
            locks.put(OBJYCDOIDUtil.getCDOID(((ooObj)itr.next()).getOid()), IDurableLockingManager.LockGrade.WRITE);
        }
        itr = this.readWriteLockSet.iterator();
        while (itr.hasNext()) {
            locks.put(OBJYCDOIDUtil.getCDOID(((ooObj)itr.next()).getOid()), IDurableLockingManager.LockGrade.READ_WRITE);
        }
        return locks;
    }

    public String toString() {
        this.fetch();
        return MessageFormat.format("ObjyLockArea[id={0}, user={1}, branchPoint={2}, readOnly={3}, readlocks={4}, writeLocks{5}, readWriteLocks{6}", new Object[]{this.durableLockingID, this.userID, this.branchPoint, this.readOnly, this.readLockSet.size(), this.writeLockSet.size(), this.readWriteLockSet.size()});
    }
}

