/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.objectivity.schema;

import com.objy.as.app.Class_Object;
import com.objy.as.app.Proposed_Class;
import com.objy.as.app.String_Value;
import com.objy.as.app.d_Access_Kind;
import com.objy.as.app.d_Class;
import com.objy.as.app.d_Module;
import com.objy.db.app.ooId;
import org.eclipse.emf.cdo.server.internal.objectivity.bundle.OM;
import org.eclipse.emf.cdo.server.internal.objectivity.db.ObjySchema;
import org.eclipse.net4j.util.om.trace.ContextTracer;

public class ObjyProxy {
    private static final ContextTracer TRACER_DEBUG = new ContextTracer(OM.DEBUG, ObjyProxy.class);
    public static String className = "ObjyProxy";
    public static String uriAttributeName = "uri";
    protected Class_Object classObject;

    public static void buildSchema() {
        d_Module top_mod = ObjySchema.getTopModule();
        if (top_mod.resolve_class(className) == null && top_mod.resolve_proposed_class(className) == null) {
            if (TRACER_DEBUG.isEnabled()) {
                TRACER_DEBUG.trace("Schema not found for ooArrayListId. Adding ooArrayListId");
            }
            boolean inProcess = top_mod.proposed_classes().hasNext();
            Proposed_Class propClass = top_mod.propose_new_class(className);
            propClass.add_base_class(-1, d_Access_Kind.d_PUBLIC, "ooObj");
            propClass.add_embedded_class_attribute(-1, d_Access_Kind.d_PROTECTED, uriAttributeName, 1L, "ooUtf8String");
            if (!inProcess) {
                top_mod.activate_proposals(true, true);
            }
            if (TRACER_DEBUG.isEnabled()) {
                TRACER_DEBUG.trace("SCHEMA changed : ooProxy added");
            }
        }
    }

    public static ObjyProxy createObject(ooId nearObject) {
        Class_Object newClassObject = Class_Object.new_persistent_object((d_Class)ObjySchema.getObjyClass(className).getASClass(), (ooId)nearObject, (boolean)false);
        ObjyProxy proxyObject = new ObjyProxy(newClassObject);
        return proxyObject;
    }

    public ObjyProxy(Class_Object classObject) {
        this.classObject = classObject;
    }

    public void setUri(String uri) {
        String_Value stringValue = this.classObject.nget_string(uriAttributeName);
        stringValue.set(uri);
    }

    public String getUri() {
        String_Value stringValue = this.classObject.nget_string(uriAttributeName);
        return stringValue.toString();
    }

    public ooId ooId() {
        return this.classObject.objectID();
    }
}

