/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.objectivity.utils;

import com.objy.db.ObjyRuntimeException;
import com.objy.db.app.ooId;
import org.eclipse.emf.cdo.server.internal.objectivity.bundle.OM;
import org.eclipse.emf.cdo.server.internal.objectivity.db.ObjyCommitInfoHandler;
import org.eclipse.emf.cdo.server.internal.objectivity.db.ObjyObject;
import org.eclipse.emf.cdo.server.internal.objectivity.db.ObjyPackageHandler;
import org.eclipse.emf.cdo.server.internal.objectivity.db.ObjyPropertyMapHandler;
import org.eclipse.emf.cdo.server.internal.objectivity.db.ObjyScope;
import org.eclipse.emf.cdo.server.internal.objectivity.schema.ObjyBranchManager;
import org.eclipse.emf.cdo.server.internal.objectivity.schema.ObjyLockAreaManager;
import org.eclipse.emf.cdo.server.internal.objectivity.schema.ObjyResourceList;
import org.eclipse.net4j.util.om.trace.ContextTracer;

public class ObjyDb {
    public static final String CONFIGDB_NAME = "ConfigDb";
    public static final String RESOURCELIST_NAME = "ResourceList";
    public static final String RESOURCELIST_CONT_NAME = "ResourceListCont";
    public static final String PACKAGESTORE_CONT_NAME = "PackageCont";
    public static final String COMMITINFOSET_CONT_NAME = "CommitInfoCont";
    public static final String COMMITINFOSET_NAME = "CommitInfoSet";
    public static final String PROPERTYMAP_NAME = "PropertyMap";
    public static final String PROPERTYMAP_CONT_NAME = "PropertyCont";
    public static final String OBJYSTOREINFO_NAME = "ObjyStoreInfo";
    public static final String DEFAULT_CONT_NAME = "_ooDefaultContObj";
    public static final String BRANCHMANAGER_NAME = "BranchManager";
    public static final String BRANCHING_CONT_NAME = "BranchingCont";
    public static final String LOCKAREAMANAGER_NAME = "LockAreaManager";
    public static final String LOCKAREA_CONT_NAME = "LockAreaCont";
    private static final ContextTracer TRACER_DEBUG = new ContextTracer(OM.DEBUG, ObjyDb.class);
    private static final String PACKAGEMAP_NAME = "PackageMap";

    public static ObjyObject getOrCreateResourceList(String repositoryName) {
        if (TRACER_DEBUG.isEnabled()) {
            TRACER_DEBUG.format("getOrCreateResourceList() for " + repositoryName, new Object[0]);
        }
        ObjyScope objyScope = new ObjyScope(repositoryName, RESOURCELIST_CONT_NAME);
        ObjyObject objyObject = null;
        try {
            objyObject = objyScope.lookupObjyObject(RESOURCELIST_NAME);
        }
        catch (ObjyRuntimeException ex) {
            objyObject = ObjyDb.createResourceList(objyScope);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return objyObject;
    }

    protected static ObjyObject createResourceList(ObjyScope objyScope) {
        if (TRACER_DEBUG.isEnabled()) {
            TRACER_DEBUG.format("createResourceList()", new Object[0]);
        }
        ObjyObject resourceList = ObjyResourceList.create(objyScope.getScopeContOid());
        objyScope.nameObj(RESOURCELIST_NAME, resourceList);
        return resourceList;
    }

    protected static ooId createCommitInfoList(ObjyScope objyScope) {
        ooId commitInfoListId = ObjyCommitInfoHandler.create(objyScope.getScopeContOid());
        objyScope.nameObj(COMMITINFOSET_NAME, commitInfoListId);
        return commitInfoListId;
    }

    public static ooId getOrCreateCommitInfoList(String repositoryName) {
        ObjyScope objyScope = new ObjyScope(repositoryName, COMMITINFOSET_CONT_NAME);
        ooId commitInfoListId = null;
        try {
            commitInfoListId = objyScope.lookupObjectOid(COMMITINFOSET_NAME);
        }
        catch (ObjyRuntimeException ex) {
            commitInfoListId = ObjyDb.createCommitInfoList(objyScope);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return commitInfoListId;
    }

    protected static ooId createPropertyMap(ObjyScope objyScope) {
        ooId propertyMapId = ObjyPropertyMapHandler.create(objyScope.getScopeContOid());
        objyScope.nameObj(PROPERTYMAP_NAME, propertyMapId);
        return propertyMapId;
    }

    public static ooId getOrCreatePropertyMap(String repositoryName) {
        ObjyScope objyScope = new ObjyScope(repositoryName, PROPERTYMAP_CONT_NAME);
        ooId propertyMapId = null;
        try {
            propertyMapId = objyScope.lookupObjectOid(PROPERTYMAP_NAME);
        }
        catch (ObjyRuntimeException ex) {
            propertyMapId = ObjyDb.createPropertyMap(objyScope);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return propertyMapId;
    }

    protected static ObjyBranchManager createBranchManager(ObjyScope objyScope) {
        ObjyBranchManager objyBranchManager = ObjyBranchManager.create(objyScope.getScopeContOid());
        objyScope.nameObj(BRANCHMANAGER_NAME, objyBranchManager.getOid());
        return objyBranchManager;
    }

    public static ObjyBranchManager getOrCreateBranchManager(String repositoryName) {
        ObjyScope objyScope = new ObjyScope(repositoryName, BRANCHING_CONT_NAME);
        ObjyBranchManager objyBranchManager = null;
        try {
            objyBranchManager = (ObjyBranchManager)objyScope.lookupObject(BRANCHMANAGER_NAME);
        }
        catch (ObjyRuntimeException ex) {
            objyBranchManager = ObjyDb.createBranchManager(objyScope);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return objyBranchManager;
    }

    protected static ObjyLockAreaManager createLockAreaManager(ObjyScope objyScope) {
        ObjyLockAreaManager objyLockAreaManager = ObjyLockAreaManager.create(objyScope.getScopeContOid());
        objyScope.nameObj(LOCKAREAMANAGER_NAME, objyLockAreaManager.getOid());
        return objyLockAreaManager;
    }

    public static ObjyLockAreaManager getOrCreateLockAreaManager(String repositoryName) {
        ObjyScope objyScope = new ObjyScope(repositoryName, LOCKAREA_CONT_NAME);
        ObjyLockAreaManager objyLockAreaManager = null;
        try {
            objyLockAreaManager = (ObjyLockAreaManager)objyScope.lookupObject(LOCKAREAMANAGER_NAME);
        }
        catch (ObjyRuntimeException ex) {
            objyLockAreaManager = ObjyDb.createLockAreaManager(objyScope);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return objyLockAreaManager;
    }

    protected static ooId createPackageMap(ObjyScope objyScope) {
        ooId packageMapId = ObjyPackageHandler.create(objyScope.getScopeContOid());
        objyScope.nameObj(PACKAGEMAP_NAME, packageMapId);
        return packageMapId;
    }

    public static ooId getOrCreatePackageMap(String repositoryName) {
        ObjyScope objyScope = new ObjyScope(repositoryName, PACKAGESTORE_CONT_NAME);
        ooId packageMapId = null;
        try {
            packageMapId = objyScope.lookupObjectOid(PACKAGEMAP_NAME);
        }
        catch (ObjyRuntimeException ex) {
            packageMapId = ObjyDb.createPackageMap(objyScope);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return packageMapId;
    }
}

