/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.internal.adapterfactory;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ForwardingListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimaps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.emf.compare.internal.adapterfactory.RankedAdapterFactoryDescriptor;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RankedAdapterFactoryDescriptorRegistryImpl
extends ForwardingListMultimap<Collection<?>, ComposedAdapterFactory.Descriptor>
implements RankedAdapterFactoryDescriptor.Registry {
    private ComposedAdapterFactory.Descriptor.Registry delegateRegistry;
    private final ListMultimap<Collection<?>, ComposedAdapterFactory.Descriptor> map;

    public RankedAdapterFactoryDescriptorRegistryImpl(ComposedAdapterFactory.Descriptor.Registry delegateRegistry) {
        this.delegateRegistry = delegateRegistry;
        this.map = Multimaps.synchronizedListMultimap((ListMultimap)ArrayListMultimap.create());
    }

    public ComposedAdapterFactory.Descriptor getDescriptor(Collection<?> types) {
        ComposedAdapterFactory.Descriptor ret = null;
        ArrayList<String> stringTypes = new ArrayList<String>(types.size());
        for (Object key : types) {
            if (key instanceof EPackage) {
                stringTypes.add(((EPackage)key).getNsURI());
                continue;
            }
            if (key instanceof Package) {
                stringTypes.add(((Package)key).getName());
                continue;
            }
            if (!(key instanceof Class)) continue;
            stringTypes.add(((Class)key).getName());
        }
        Iterator descriptors = this.get(stringTypes).iterator();
        if (descriptors.hasNext()) {
            ComposedAdapterFactory.Descriptor highestRanking = (ComposedAdapterFactory.Descriptor)descriptors.next();
            while (descriptors.hasNext()) {
                ComposedAdapterFactory.Descriptor descriptor = (ComposedAdapterFactory.Descriptor)descriptors.next();
                if (!(descriptor instanceof RankedAdapterFactoryDescriptor)) continue;
                if (highestRanking instanceof RankedAdapterFactoryDescriptor) {
                    if (((RankedAdapterFactoryDescriptor)descriptor).getRanking() <= ((RankedAdapterFactoryDescriptor)highestRanking).getRanking()) continue;
                    highestRanking = descriptor;
                    continue;
                }
                highestRanking = descriptor;
            }
            ret = highestRanking;
        }
        if (ret != null) {
            this.put(types, ret);
        }
        return ret == null ? this.delegatedGetDescriptor(types) : ret;
    }

    protected ComposedAdapterFactory.Descriptor delegatedGetDescriptor(Collection<?> types) {
        if (this.delegateRegistry != null) {
            return this.delegateRegistry.getDescriptor(types);
        }
        return null;
    }

    public ListMultimap<Collection<?>, ComposedAdapterFactory.Descriptor> delegate() {
        return this.map;
    }
}

