/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.transforms;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.equinox.internal.transforms.LazyInputStream;
import org.eclipse.equinox.internal.transforms.StreamTransformer;
import org.eclipse.equinox.internal.transforms.TransformTuple;
import org.eclipse.equinox.internal.transforms.TransformedBundleEntry;
import org.eclipse.equinox.internal.transforms.TransformerHook;
import org.eclipse.osgi.baseadaptor.BaseData;
import org.eclipse.osgi.baseadaptor.bundlefile.BundleEntry;
import org.eclipse.osgi.baseadaptor.bundlefile.BundleFile;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.internal.baseadaptor.AdaptorMsg;
import org.eclipse.osgi.internal.baseadaptor.AdaptorUtil;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;

public class TransformedBundleFile
extends BundleFile {
    private final TransformerHook transformerHook;
    private final BundleFile delegate;
    private final BaseData data;

    public TransformedBundleFile(TransformerHook transformerHook, BaseData data, BundleFile delegate) {
        this.transformerHook = transformerHook;
        this.data = data;
        this.delegate = delegate;
    }

    public void close() throws IOException {
        this.delegate.close();
    }

    public boolean containsDir(String dir) {
        return this.delegate.containsDir(dir);
    }

    public boolean equals(Object obj) {
        return this.delegate.equals(obj);
    }

    public File getBaseFile() {
        return this.delegate.getBaseFile();
    }

    public BundleEntry getEntry(String path) {
        final BundleEntry original = this.delegate.getEntry(path);
        if (this.data.getBundle() == null || path == null || original == null) {
            return original;
        }
        LazyInputStream stream = new LazyInputStream(new LazyInputStream.InputStreamProvider(){

            public InputStream getInputStream() throws IOException {
                return original.getInputStream();
            }
        });
        InputStream wrappedStream = this.getInputStream(stream, this.data.getBundle(), path);
        if (wrappedStream == null) {
            return original;
        }
        return new TransformedBundleEntry(this, original, wrappedStream);
    }

    protected InputStream getInputStream(InputStream inputStream, Bundle bundle, String path) {
        String namespace = bundle.getSymbolicName();
        String[] transformTypes = this.transformerHook.getTransformTypes();
        if (transformTypes.length == 0) {
            return null;
        }
        int i = 0;
        while (i < transformTypes.length) {
            TransformTuple[] transformTuples;
            StreamTransformer transformer = this.transformerHook.getTransformer(transformTypes[i]);
            if (transformer != null && (transformTuples = this.transformerHook.getTransformsFor(transformTypes[i])) != null) {
                int j = 0;
                while (j < transformTuples.length) {
                    TransformTuple transformTuple = transformTuples[j];
                    if (this.match(transformTuple.bundlePattern, namespace) && this.match(transformTuple.pathPattern, path)) {
                        try {
                            return transformer.getInputStream(inputStream, transformTuple.transformerUrl);
                        }
                        catch (IOException e) {
                            TransformerHook.log(4, "Problem obtaining transformed stream from transformer : " + transformer.getClass().getName(), e);
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        return null;
    }

    private boolean match(Pattern pattern, String string) {
        Matcher matcher = pattern.matcher(string);
        return matcher.matches();
    }

    public Enumeration getEntryPaths(String path) {
        return this.delegate.getEntryPaths(path);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public File getFile(String path, boolean nativeCode) {
        InputStream in;
        File nested;
        block11: {
            File originalFile = this.delegate.getFile(path, nativeCode);
            if (originalFile == null) {
                return null;
            }
            if (!this.hasTransforms(path)) {
                return originalFile;
            }
            nested = this.getExtractFile(path);
            if (nested == null) return null;
            if (nested.exists()) {
                if (Debug.DEBUG_GENERAL) {
                    Debug.println((String)("File already present: " + nested.getPath()));
                }
                if (!nested.isDirectory()) return nested;
                this.extractDirectory(path);
                return nested;
            }
            if (originalFile.isDirectory()) {
                if (!nested.mkdirs()) {
                    if (!Debug.DEBUG_GENERAL) throw new IOException(NLS.bind((String)AdaptorMsg.ADAPTOR_DIRECTORY_CREATE_EXCEPTION, (Object)nested.getAbsolutePath()));
                    Debug.println((String)("Unable to create directory: " + nested.getPath()));
                    throw new IOException(NLS.bind((String)AdaptorMsg.ADAPTOR_DIRECTORY_CREATE_EXCEPTION, (Object)nested.getAbsolutePath()));
                }
                this.extractDirectory(path);
                return nested;
            }
            in = this.getEntry(path).getInputStream();
            if (in != null) break block11;
            return null;
        }
        try {
            File dir;
            if (Debug.DEBUG_GENERAL) {
                Debug.println((String)("Creating file: " + nested.getPath()));
            }
            if (!(dir = new File(nested.getParent())).exists() && !dir.mkdirs()) {
                if (!Debug.DEBUG_GENERAL) throw new IOException(NLS.bind((String)AdaptorMsg.ADAPTOR_DIRECTORY_CREATE_EXCEPTION, (Object)dir.getAbsolutePath()));
                Debug.println((String)("Unable to create directory: " + dir.getPath()));
                throw new IOException(NLS.bind((String)AdaptorMsg.ADAPTOR_DIRECTORY_CREATE_EXCEPTION, (Object)dir.getAbsolutePath()));
            }
            AdaptorUtil.readFile((InputStream)in, (File)nested);
            if (!nativeCode) return nested;
            TransformedBundleFile.setPermissions((File)nested);
            return nested;
        }
        catch (IOException e) {
            if (!Debug.DEBUG_GENERAL) return null;
            Debug.printStackTrace((Throwable)e);
        }
        return null;
    }

    private boolean hasTransforms(String path) {
        if (!this.transformerHook.hasTransformers()) {
            return false;
        }
        return this.transformerHook.hasTransformsFor(this.data.getBundle());
    }

    protected synchronized File extractDirectory(String dirName) {
        Enumeration entries = this.delegate.getEntryPaths(dirName);
        while (entries.hasMoreElements()) {
            String entryPath = (String)entries.nextElement();
            if (!entryPath.startsWith(dirName)) continue;
            this.getFile(entryPath, false);
        }
        return this.getExtractFile(dirName);
    }

    protected File getExtractFile(String entryName) {
        if (this.data == null) {
            return null;
        }
        String path = ".tf";
        String name = entryName.replace('/', File.separatorChar);
        path = name.length() > 1 && name.charAt(0) == File.separatorChar ? path.concat(name) : String.valueOf(path) + File.separator + name;
        return this.data.getExtractFile(path);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public void open() throws IOException {
        this.delegate.open();
    }

    public String toString() {
        return this.delegate.toString();
    }
}

