/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.nosql.mongodb;

import com.mongodb.BasicDBObject;
import com.mongodb.BasicDBObjectBuilder;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.Mongo;
import com.mongodb.MongoException;
import java.net.UnknownHostException;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.eclipse.jetty.nosql.mongodb.MongoSessionManager;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.SessionManager;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.session.AbstractSessionIdManager;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class MongoSessionIdManager
extends AbstractSessionIdManager {
    private static final Logger __log = Log.getLogger((String)"org.eclipse.jetty.server.session");
    static final DBObject __version_1 = new BasicDBObject("__metadata__.version", (Object)1);
    static final DBObject __valid_false = new BasicDBObject("valid", (Object)false);
    static final DBObject __valid_true = new BasicDBObject("valid", (Object)true);
    final DBCollection _sessions;
    protected Server _server;
    private Timer _scavengeTimer;
    private Timer _purgeTimer;
    private TimerTask _scavengerTask;
    private TimerTask _purgeTask;
    private long _scavengeDelay = 1800000L;
    private long _scavengePeriod = 60000L;
    private boolean _purge = true;
    private long _purgeDelay = 86400000L;
    private long _purgeInvalidAge = 86400000L;
    private long _purgeValidAge = 604800000L;
    protected final Set<String> _sessionsIds = new HashSet<String>();

    public MongoSessionIdManager(Server server) throws UnknownHostException, MongoException {
        this(server, new Mongo().getDB("HttpSessions").getCollection("sessions"));
    }

    public MongoSessionIdManager(Server server, DBCollection sessions) {
        super(new Random());
        this._server = server;
        this._sessions = sessions;
        this._sessions.ensureIndex(BasicDBObjectBuilder.start().add("id", (Object)1).get(), BasicDBObjectBuilder.start().add("unique", (Object)true).add("sparse", (Object)false).get());
        this._sessions.ensureIndex(BasicDBObjectBuilder.start().add("id", (Object)1).add("version", (Object)1).get(), BasicDBObjectBuilder.start().add("unique", (Object)true).add("sparse", (Object)false).get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void scavenge() {
        __log.debug("SessionIdManager:scavenge:called with delay" + this._scavengeDelay, new Object[0]);
        Set<String> set = this._sessionsIds;
        synchronized (set) {
            BasicDBObject query = new BasicDBObject();
            query.put("id", (Object)new BasicDBObject("$in", this._sessionsIds));
            query.put("accessed", (Object)new BasicDBObject("$lt", (Object)(System.currentTimeMillis() - this._scavengeDelay)));
            DBCursor checkSessions = this._sessions.find((DBObject)query, (DBObject)new BasicDBObject("id", (Object)1));
            for (DBObject session : checkSessions) {
                __log.debug("SessionIdManager:scavenge: invalidating " + (String)session.get("id"), new Object[0]);
                this.invalidateAll((String)session.get("id"));
            }
        }
    }

    protected void scavengeFully() {
        __log.debug("SessionIdManager:scavengeFully", new Object[0]);
        DBCursor checkSessions = this._sessions.find();
        for (DBObject session : checkSessions) {
            this.invalidateAll((String)session.get("id"));
        }
    }

    protected void purge() {
        BasicDBObject invalidQuery = new BasicDBObject();
        invalidQuery.put("accessed", (Object)new BasicDBObject("$lt", (Object)(System.currentTimeMillis() - this._purgeInvalidAge)));
        invalidQuery.put("valid", (Object)__valid_false);
        DBCursor oldSessions = this._sessions.find((DBObject)invalidQuery, (DBObject)new BasicDBObject("id", (Object)1));
        for (DBObject session : oldSessions) {
            String id = (String)session.get("id");
            __log.debug("MongoSessionIdManager:purging invalid " + id, new Object[0]);
            this._sessions.remove(session);
        }
        if (this._purgeValidAge != 0L) {
            BasicDBObject validQuery = new BasicDBObject();
            validQuery.put("accessed", (Object)new BasicDBObject("$lt", (Object)(System.currentTimeMillis() - this._purgeValidAge)));
            validQuery.put("valid", (Object)__valid_false);
            oldSessions = this._sessions.find((DBObject)invalidQuery, (DBObject)new BasicDBObject("id", (Object)1));
            for (DBObject session : oldSessions) {
                String id = (String)session.get("id");
                __log.debug("MongoSessionIdManager:purging valid " + id, new Object[0]);
                this._sessions.remove(session);
            }
        }
    }

    protected void purgeFully() {
        BasicDBObject invalidQuery = new BasicDBObject();
        invalidQuery.put("valid", (Object)false);
        DBCursor oldSessions = this._sessions.find((DBObject)invalidQuery, (DBObject)new BasicDBObject("id", (Object)1));
        for (DBObject session : oldSessions) {
            String id = (String)session.get("id");
            __log.debug("MongoSessionIdManager:purging invalid " + id, new Object[0]);
            this._sessions.remove(session);
        }
    }

    public DBCollection getSessions() {
        return this._sessions;
    }

    public boolean isPurgeEnabled() {
        return this._purge;
    }

    public void setPurge(boolean purge) {
        this._purge = purge;
    }

    public void setScavengeDelay(long scavengeDelay) {
        this._scavengeDelay = scavengeDelay;
    }

    public void setScavengePeriod(long scavengePeriod) {
        this._scavengePeriod = scavengePeriod;
    }

    public void setPurgeDelay(long purgeDelay) {
        if (this.isRunning()) {
            throw new IllegalStateException();
        }
        this._purgeDelay = purgeDelay;
    }

    public long getPurgeInvalidAge() {
        return this._purgeInvalidAge;
    }

    public void setPurgeInvalidAge(long purgeValidAge) {
        this._purgeInvalidAge = purgeValidAge;
    }

    public long getPurgeValidAge() {
        return this._purgeValidAge;
    }

    public void setPurgeValidAge(long purgeValidAge) {
        this._purgeValidAge = purgeValidAge;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStart() throws Exception {
        MongoSessionIdManager mongoSessionIdManager;
        __log.debug("MongoSessionIdManager:starting", new Object[0]);
        if (this._scavengeDelay > 0L) {
            this._scavengeTimer = new Timer("MongoSessionIdScavenger", true);
            mongoSessionIdManager = this;
            synchronized (mongoSessionIdManager) {
                if (this._scavengerTask != null) {
                    this._scavengerTask.cancel();
                }
                this._scavengerTask = new TimerTask(){

                    @Override
                    public void run() {
                        MongoSessionIdManager.this.scavenge();
                    }
                };
                this._scavengeTimer.schedule(this._scavengerTask, this._scavengeDelay, this._scavengePeriod);
            }
        }
        if (this._purge) {
            this._purgeTimer = new Timer("MongoSessionPurger", true);
            mongoSessionIdManager = this;
            synchronized (mongoSessionIdManager) {
                if (this._purgeTask != null) {
                    this._purgeTask.cancel();
                }
                this._purgeTask = new TimerTask(){

                    @Override
                    public void run() {
                        MongoSessionIdManager.this.purge();
                    }
                };
                this._purgeTimer.schedule(this._purgeTask, this._purgeDelay);
            }
        }
    }

    protected void doStop() throws Exception {
        if (this._scavengeTimer != null) {
            this._scavengeTimer.cancel();
            this._scavengeTimer = null;
        }
        if (this._purgeTimer != null) {
            this._purgeTimer.cancel();
            this._purgeTimer = null;
        }
        super.doStop();
    }

    public boolean idInUse(String sessionId) {
        DBObject o = this._sessions.findOne((DBObject)new BasicDBObject("id", (Object)sessionId), __valid_true);
        if (o != null) {
            Boolean valid = (Boolean)o.get("valid");
            if (valid == null) {
                return false;
            }
            return valid;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSession(HttpSession session) {
        if (session == null) {
            return;
        }
        __log.debug("MongoSessionIdManager:addSession:" + session.getId(), new Object[0]);
        Set<String> set = this._sessionsIds;
        synchronized (set) {
            this._sessionsIds.add(session.getId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSession(HttpSession session) {
        if (session == null) {
            return;
        }
        Set<String> set = this._sessionsIds;
        synchronized (set) {
            this._sessionsIds.remove(session.getId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateAll(String sessionId) {
        Set<String> set = this._sessionsIds;
        synchronized (set) {
            this._sessionsIds.remove(sessionId);
            Handler[] contexts = this._server.getChildHandlersByClass(ContextHandler.class);
            for (int i = 0; contexts != null && i < contexts.length; ++i) {
                SessionManager manager;
                SessionHandler sessionHandler = (SessionHandler)((ContextHandler)contexts[i]).getChildHandlerByClass(SessionHandler.class);
                if (sessionHandler == null || (manager = sessionHandler.getSessionManager()) == null || !(manager instanceof MongoSessionManager)) continue;
                ((MongoSessionManager)manager).invalidateSession(sessionId);
            }
        }
    }

    public String getClusterId(String nodeId) {
        int dot = nodeId.lastIndexOf(46);
        return dot > 0 ? nodeId.substring(0, dot) : nodeId;
    }

    public String getNodeId(String clusterId, HttpServletRequest request) {
        if (this._workerName != null) {
            return clusterId + '.' + this._workerName;
        }
        return clusterId;
    }
}

