/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.spi.db;

import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.net4j.db.DBException;
import org.eclipse.net4j.db.DBType;
import org.eclipse.net4j.db.DBUtil;
import org.eclipse.net4j.db.IDBAdapter;
import org.eclipse.net4j.db.ddl.IDBField;
import org.eclipse.net4j.db.ddl.IDBIndex;
import org.eclipse.net4j.db.ddl.IDBTable;
import org.eclipse.net4j.internal.db.bundle.OM;
import org.eclipse.net4j.util.om.trace.ContextTracer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DBAdapter
implements IDBAdapter {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_SQL, DBAdapter.class);
    private static final String[] SQL92_RESERVED_WORDS = new String[]{"ABSOLUTE", "ACTION", "ADD", "AFTER", "ALL", "ALLOCATE", "ALTER", "AND", "ANY", "ARE", "ARRAY", "AS", "ASC", "ASENSITIVE", "ASSERTION", "ASYMMETRIC", "AT", "ATOMIC", "AUTHORIZATION", "AVG", "BEFORE", "BEGIN", "BETWEEN", "BIGINT", "BINARY", "BIT", "BIT_LENGTH", "BLOB", "BOOLEAN", "BOTH", "BREADTH", "BY", "CALL", "CALLED", "CASCADE", "CASCADED", "CASE", "CAST", "CATALOG", "CHAR", "CHARACTER", "CHARACTER_LENGTH", "CHAR_LENGTH", "CHECK", "CLOB", "CLOSE", "COALESCE", "COLLATE", "COLLATION", "COLUMN", "COMMIT", "CONDITION", "CONNECT", "CONNECTION", "CONSTRAINT", "CONSTRAINTS", "CONSTRUCTOR", "CONTAINS", "CONTINUE", "CONVERT", "CORRESPONDING", "COUNT", "CREATE", "CROSS", "CUBE", "CURRENT", "CURRENT_DATE", "CURRENT_DEFAULT_TRANSFORM_GROUP", "CURRENT_PATH", "CURRENT_ROLE", "CURRENT_TIME", "CURRENT_TIMESTAMP", "CURRENT_TRANSFORM_GROUP_FOR_TYPE", "CURRENT_USER", "CURSOR", "CYCLE", "DATA", "DATE", "DAY", "DEALLOCATE", "DEC", "DECIMAL", "DECLARE", "DEFAULT", "DEFERRABLE", "DEFERRED", "DELETE", "DEPTH", "DEREF", "DESC", "DESCRIBE", "DESCRIPTOR", "DETERMINISTIC", "DIAGNOSTICS", "DISCONNECT", "DISTINCT", "DO", "DOMAIN", "DOUBLE", "DROP", "DYNAMIC", "EACH", "ELEMENT", "ELSE", "ELSEIF", "END", "EQUALS", "ESCAPE", "EXCEPT", "EXCEPTION", "EXEC", "EXECUTE", "EXISTS", "EXIT", "EXTERNAL", "EXTRACT", "FALSE", "FETCH", "FILTER", "FIRST", "FLOAT", "FOR", "FOREIGN", "FOUND", "FREE", "FROM", "FULL", "FUNCTION", "GENERAL", "GET", "GLOBAL", "GO", "GOTO", "GRANT", "GROUP", "GROUPING", "HANDLER", "HAVING", "HOLD", "HOUR", "IDENTITY", "IF", "IMMEDIATE", "IN", "INDICATOR", "INITIALLY", "INNER", "INOUT", "INPUT", "INSENSITIVE", "INSERT", "INT", "INTEGER", "INTERSECT", "INTERVAL", "INTO", "IS", "ISOLATION", "ITERATE", "JOIN", "KEY", "LANGUAGE", "LARGE", "LAST", "LATERAL", "LEADING", "LEAVE", "LEFT", "LEVEL", "LIKE", "LOCAL", "LOCALTIME", "LOCALTIMESTAMP", "LOCATOR", "LOOP", "LOWER", "MAP", "MATCH", "MAX", "MEMBER", "MERGE", "METHOD", "MIN", "MINUTE", "MODIFIES", "MODULE", "MONTH", "MULTISET", "NAMES", "NATIONAL", "NATURAL", "NCHAR", "NCLOB", "NEW", "NEXT", "NO", "NONE", "NOT", "NULL", "NULLIF", "NUMERIC", "OBJECT", "OCTET_LENGTH", "OF", "OLD", "ON", "ONLY", "OPEN", "OPTION", "OR", "ORDER", "ORDINALITY", "OUT", "OUTER", "OUTPUT", "OVER", "OVERLAPS", "PAD", "PARAMETER", "PARTIAL", "PARTITION", "PATH", "POSITION", "PRECISION", "PREPARE", "PRESERVE", "PRIMARY", "PRIOR", "PRIVILEGES", "PROCEDURE", "PUBLIC", "RANGE", "READ", "READS", "REAL", "RECURSIVE", "REF", "REFERENCES", "REFERENCING", "RELATIVE", "RELEASE", "REPEAT", "RESIGNAL", "RESTRICT", "RESULT", "RETURN", "RETURNS", "REVOKE", "RIGHT", "ROLE", "ROLLBACK", "ROLLUP", "ROUTINE", "ROW", "ROWS", "SAVEPOINT", "SCHEMA", "SCOPE", "SCROLL", "SEARCH", "SECOND", "SECTION", "SELECT", "SENSITIVE", "SESSION", "SESSION_USER", "SET", "SETS", "SIGNAL", "SIMILAR", "SIZE", "SMALLINT", "SOME", "SPACE", "SPECIFIC", "SPECIFICTYPE", "SQL", "SQLCODE", "SQLERROR", "SQLEXCEPTION", "SQLSTATE", "SQLWARNING", "START", "STATE", "STATIC", "SUBMULTISET", "SUBSTRING", "SUM", "SYMMETRIC", "SYSTEM", "SYSTEM_USER", "TABLE", "TABLESAMPLE", "TEMPORARY", "THEN", "TIME", "TIMESTAMP", "TIMEZONE_HOUR", "TIMEZONE_MINUTE", "TO", "TRAILING", "TRANSACTION", "TRANSLATE", "TRANSLATION", "TREAT", "TRIGGER", "TRIM", "TRUE", "UNDER", "UNDO", "UNION", "UNIQUE", "UNKNOWN", "UNNEST", "UNTIL", "UPDATE", "UPPER", "USAGE", "USER", "USING", "VALUE", "VALUES", "VARCHAR", "VARYING", "VIEW", "WHEN", "WHENEVER", "WHERE", "WHILE", "WINDOW", "WITH", "WITHIN", "WITHOUT", "WORK", "WRITE", "YEAR", "ZONE"};
    private String name;
    private String version;
    private Set<String> reservedWords;

    public DBAdapter(String name, String version) {
        this.name = name;
        this.version = version;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public Set<IDBTable> createTables(Iterable<? extends IDBTable> tables, Connection connection) throws DBException {
        HashSet<IDBTable> createdTables = new HashSet<IDBTable>();
        Statement statement = null;
        try {
            try {
                statement = connection.createStatement();
                for (IDBTable iDBTable : tables) {
                    if (!this.createTable(iDBTable, statement)) continue;
                    createdTables.add(iDBTable);
                }
            }
            catch (SQLException sQLException) {
                throw new DBException(sQLException);
            }
        }
        finally {
            DBUtil.close(statement);
        }
        return createdTables;
    }

    @Override
    public boolean createTable(IDBTable table, Statement statement) throws DBException {
        boolean created;
        block2: {
            created = true;
            try {
                this.doCreateTable(table, statement);
            }
            catch (SQLException ex) {
                created = false;
                if (!TRACER.isEnabled()) break block2;
                TRACER.trace("-- " + ex.getMessage());
            }
        }
        this.validateTable(table, statement);
        return created;
    }

    @Override
    public Collection<IDBTable> dropTables(Iterable<? extends IDBTable> tables, Connection connection) throws DBException {
        ArrayList<IDBTable> droppedTables = new ArrayList<IDBTable>();
        Statement statement = null;
        try {
            try {
                statement = connection.createStatement();
                for (IDBTable iDBTable : tables) {
                    if (!this.dropTable(iDBTable, statement)) continue;
                    droppedTables.add(iDBTable);
                }
            }
            catch (SQLException sQLException) {
                OM.LOG.error((Throwable)sQLException);
                DBUtil.close(statement);
            }
        }
        finally {
            DBUtil.close(statement);
        }
        return droppedTables;
    }

    @Override
    public boolean dropTable(IDBTable table, Statement statement) {
        try {
            String sql = this.getDropTableSQL(table);
            if (TRACER.isEnabled()) {
                TRACER.trace(sql);
            }
            statement.execute(sql);
            return true;
        }
        catch (SQLException ex) {
            if (TRACER.isEnabled()) {
                TRACER.trace(ex.getMessage());
            }
            return false;
        }
    }

    protected String getDropTableSQL(IDBTable table) {
        return "DROP TABLE " + table;
    }

    @Override
    public int getMaxTableNameLength() {
        return 128;
    }

    @Override
    public int getMaxFieldNameLength() {
        return 128;
    }

    @Override
    public boolean isTypeIndexable(DBType type) {
        switch (type) {
            case LONGVARCHAR: 
            case CLOB: 
            case BINARY: 
            case VARBINARY: 
            case LONGVARBINARY: 
            case BLOB: {
                return false;
            }
        }
        return true;
    }

    public String toString() {
        return String.valueOf(this.getName()) + "-" + this.getVersion();
    }

    protected void doCreateTable(IDBTable table, Statement statement) throws SQLException {
        StringBuilder builder = new StringBuilder();
        builder.append("CREATE TABLE ");
        builder.append(table);
        builder.append(" (");
        this.appendFieldDefs(builder, table, this.createFieldDefinitions(table));
        String constraints = this.createConstraints(table);
        if (constraints != null) {
            builder.append(", ");
            builder.append(constraints);
        }
        builder.append(")");
        String sql = builder.toString();
        if (TRACER.isEnabled()) {
            TRACER.trace(sql);
        }
        statement.execute(sql);
        IDBIndex[] indices = table.getIndices();
        int i = 0;
        while (i < indices.length) {
            this.createIndex(indices[i], statement, i);
            ++i;
        }
    }

    protected void createIndex(IDBIndex index, Statement statement, int num) throws SQLException {
        IDBTable table = index.getTable();
        StringBuilder builder = new StringBuilder();
        builder.append("CREATE ");
        if (index.getType() == IDBIndex.Type.UNIQUE || index.getType() == IDBIndex.Type.PRIMARY_KEY) {
            builder.append("UNIQUE ");
        }
        builder.append("INDEX ");
        builder.append(table);
        builder.append("_idx");
        builder.append(num);
        builder.append(" ON ");
        builder.append(table);
        builder.append(" (");
        IDBField[] fields = index.getFields();
        int i = 0;
        while (i < fields.length) {
            if (i != 0) {
                builder.append(", ");
            }
            this.addIndexField(builder, fields[i]);
            ++i;
        }
        builder.append(")");
        String sql = builder.toString();
        if (TRACER.isEnabled()) {
            TRACER.trace(sql);
        }
        statement.execute(sql);
    }

    protected void addIndexField(StringBuilder builder, IDBField field) {
        builder.append(field);
    }

    protected String createConstraints(IDBTable table) {
        return null;
    }

    protected String createFieldDefinition(IDBField field) {
        return String.valueOf(this.getTypeName(field)) + (field.isNotNull() ? " NOT NULL" : "");
    }

    protected String getTypeName(IDBField field) {
        DBType type = field.getType();
        switch (type) {
            case BOOLEAN: 
            case BIT: 
            case TINYINT: 
            case SMALLINT: 
            case INTEGER: 
            case BIGINT: 
            case FLOAT: 
            case REAL: 
            case DOUBLE: 
            case LONGVARCHAR: 
            case CLOB: 
            case DATE: 
            case TIME: 
            case TIMESTAMP: 
            case LONGVARBINARY: 
            case BLOB: {
                return type.toString();
            }
            case CHAR: 
            case VARCHAR: 
            case BINARY: 
            case VARBINARY: {
                return String.valueOf(type.toString()) + field.formatPrecision();
            }
            case NUMERIC: 
            case DECIMAL: {
                return String.valueOf(type.toString()) + field.formatPrecisionAndScale();
            }
        }
        throw new IllegalArgumentException("Unknown type: " + (Object)((Object)type));
    }

    public String[] getSQL92ReservedWords() {
        return SQL92_RESERVED_WORDS;
    }

    @Override
    public boolean isReservedWord(String word) {
        if (this.reservedWords == null) {
            this.reservedWords = new HashSet<String>();
            String[] stringArray = this.getReservedWords();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String reservedWord = stringArray[n2];
                this.reservedWords.add(reservedWord.toUpperCase());
                ++n2;
            }
        }
        word = word.toUpperCase();
        return this.reservedWords.contains(word);
    }

    protected void validateTable(IDBTable table, Statement statement) throws DBException {
        int maxRows = 1;
        try {
            maxRows = statement.getMaxRows();
            statement.setMaxRows(1);
            String sql = null;
            try {
                try {
                    ResultSet resultSet;
                    ResultSetMetaData metaData;
                    int columnCount;
                    StringBuilder builder = new StringBuilder();
                    builder.append("SELECT ");
                    this.appendFieldNames(builder, table);
                    builder.append(" FROM ");
                    builder.append(table);
                    sql = builder.toString();
                    if (TRACER.isEnabled()) {
                        TRACER.format("{0}", new Object[]{sql});
                    }
                    if ((columnCount = (metaData = (resultSet = statement.executeQuery(sql)).getMetaData()).getColumnCount()) != table.getFieldCount()) {
                        throw new DBException("DBTable " + table + " has " + columnCount + " columns instead of " + table.getFieldCount());
                    }
                }
                catch (SQLException ex) {
                    throw new DBException("Problem with table " + table, ex, sql);
                }
            }
            finally {
                if (maxRows != 1) {
                    statement.setMaxRows(1);
                }
            }
        }
        catch (SQLException ex) {
            throw new DBException(ex);
        }
    }

    private String[] createFieldDefinitions(IDBTable table) {
        IDBField[] fields = table.getFields();
        int fieldCount = fields.length;
        String[] result = new String[fieldCount];
        int i = 0;
        while (i < fieldCount) {
            IDBField field = fields[i];
            result[i] = this.createFieldDefinition(field);
            ++i;
        }
        return result;
    }

    public void appendFieldNames(Appendable appendable, IDBTable table) {
        try {
            IDBField[] fields = table.getFields();
            int i = 0;
            while (i < fields.length) {
                IDBField field = fields[i];
                if (i != 0) {
                    appendable.append(", ");
                }
                String fieldName = field.getName();
                appendable.append(fieldName);
                ++i;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void appendFieldDefs(Appendable appendable, IDBTable table, String[] defs) {
        try {
            IDBField[] fields = table.getFields();
            int i = 0;
            while (i < fields.length) {
                IDBField field = fields[i];
                if (i != 0) {
                    appendable.append(", ");
                }
                String fieldName = field.getName();
                appendable.append(fieldName);
                appendable.append(" ");
                appendable.append(defs[i]);
                ++i;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public DBType adaptType(DBType type) {
        return type;
    }

    @Override
    public boolean isValidFirstChar(char ch) {
        return true;
    }

    @Override
    public boolean isDuplicateKeyException(SQLException ex) {
        return "23001".equals(ex.getSQLState());
    }
}

