/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.internal.jvm;

import java.nio.ByteBuffer;
import java.util.Queue;
import org.eclipse.net4j.buffer.IBuffer;
import org.eclipse.net4j.channel.ChannelException;
import org.eclipse.net4j.internal.jvm.JVMChannel;
import org.eclipse.net4j.internal.jvm.bundle.OM;
import org.eclipse.net4j.internal.jvm.messages.Messages;
import org.eclipse.net4j.jvm.IJVMConnector;
import org.eclipse.net4j.protocol.IProtocol;
import org.eclipse.net4j.util.om.trace.ContextTracer;
import org.eclipse.net4j.util.security.INegotiationContext;
import org.eclipse.spi.net4j.Connector;
import org.eclipse.spi.net4j.InternalChannel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JVMConnector
extends Connector
implements IJVMConnector {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG, JVMConnector.class);
    private JVMConnector peer;
    private String name;

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public JVMConnector getPeer() {
        return this.peer;
    }

    public void setPeer(JVMConnector peer) {
        this.peer = peer;
    }

    public String getURL() {
        return "jvm://" + this.name;
    }

    public void multiplexChannel(InternalChannel localChannel) {
        short channelID = localChannel.getID();
        InternalChannel peerChannel = this.peer.getChannel(channelID);
        if (peerChannel == null) {
            throw new IllegalStateException("peerChannel == null");
        }
        Queue localQueue = localChannel.getSendQueue();
        IBuffer buffer = (IBuffer)localQueue.poll();
        ByteBuffer byteBuffer = buffer.getByteBuffer();
        if (byteBuffer.position() == 4) {
            buffer.release();
            return;
        }
        if (TRACER.isEnabled()) {
            TRACER.trace("Multiplexing " + buffer.formatContent(true));
        }
        buffer.flip();
        peerChannel.handleBufferFromMultiplexer(buffer);
    }

    protected INegotiationContext createNegotiationContext() {
        throw new UnsupportedOperationException();
    }

    protected InternalChannel createChannel() {
        return new JVMChannel();
    }

    protected void registerChannelWithPeer(short channelID, long timeoutIgnored, IProtocol<?> protocol) throws ChannelException {
        try {
            String protocolID = protocol == null ? null : protocol.getType();
            JVMChannel peerChannel = (JVMChannel)this.peer.inverseOpenChannel(channelID, protocolID);
            if (peerChannel == null) {
                throw new ChannelException(Messages.getString("JVMConnector.2"));
            }
            JVMChannel c = (JVMChannel)this.getChannel(channelID);
            c.setPeer(peerChannel);
            peerChannel.setPeer(c);
        }
        catch (ChannelException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ChannelException((Throwable)ex);
        }
    }

    protected void deregisterChannelFromPeer(InternalChannel channel) throws ChannelException {
        try {
            this.getPeer().inverseCloseChannel(channel.getID());
        }
        catch (ChannelException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ChannelException((Throwable)ex);
        }
    }

    protected void doBeforeActivate() throws Exception {
        super.doBeforeActivate();
        this.checkState(this.name, "name");
    }

    protected void doActivate() throws Exception {
        super.doActivate();
        this.leaveConnecting();
    }
}

