/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.common;

import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.ocl.common.OCLConstants;
import org.eclipse.ocl.common.preferences.PreferenceableOption;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OCLCommon
implements OCLConstants {
    public static final String PLUGIN_ID = "org.eclipse.ocl.common";

    public static EAnnotation getDelegateAnnotation(EModelElement eModelElement) {
        String source;
        EList eAnnotations = eModelElement.getEAnnotations();
        for (EAnnotation eAnnotation : eAnnotations) {
            source = eAnnotation.getSource();
            if (source == null || !source.equals("http://www.eclipse.org/emf/2002/Ecore/OCL")) continue;
            return eAnnotation;
        }
        for (EAnnotation eAnnotation : eAnnotations) {
            source = eAnnotation.getSource();
            if (source == null || !source.startsWith("http://www.eclipse.org/emf/2002/Ecore/OCL/")) continue;
            return eAnnotation;
        }
        return null;
    }

    public static String getDelegateAnnotation(EModelElement eModelElement, String key) {
        EAnnotation eAnnotation = OCLCommon.getDelegateAnnotation(eModelElement);
        return eAnnotation == null ? null : (String)eAnnotation.getDetails().get((Object)key);
    }

    public static <T> T getPreference(PreferenceableOption<T> option, IScopeContext[] contexts) {
        IPreferencesService preferencesService = Platform.getPreferencesService();
        if (preferencesService == null) {
            return option.getDefaultValue();
        }
        String qualifier = option.getPluginId();
        String key = option.getKey();
        T defaultValue = option.getDefaultValue();
        String string = preferencesService.getString(qualifier, key, defaultValue != null ? defaultValue.toString() : "", contexts);
        return option.getValueOf(string);
    }

    public static boolean isDelegateURI(String string) {
        if (string != null) {
            if (string.equals("http://www.eclipse.org/emf/2002/Ecore/OCL")) {
                return true;
            }
            if (string.startsWith("http://www.eclipse.org/emf/2002/Ecore/OCL/")) {
                return true;
            }
        }
        return false;
    }
}

