/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor;

import java.util.List;
import java.util.Vector;
import org.eclipse.jface.action.IAction;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.IModelChangeProvider;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.IModelUndoManager;
import org.eclipse.pde.internal.ui.editor.PDEFormEditor;
import org.eclipse.ui.forms.editor.IFormPage;

public abstract class ModelUndoManager
implements IModelUndoManager,
IModelChangedListener {
    private boolean ignoreChanges;
    private List<IModelChangedEvent> operations;
    private int undoLevelLimit = 10;
    private int cursor = -1;
    private IAction undoAction;
    private IAction redoAction;
    private PDEFormEditor editor;

    public ModelUndoManager(PDEFormEditor editor) {
        this.editor = editor;
        this.operations = new Vector<IModelChangedEvent>();
    }

    public void connect(IModelChangeProvider provider) {
        provider.addModelChangedListener((IModelChangedListener)this);
        if (this.operations == null) {
            this.initialize();
        }
    }

    public void disconnect(IModelChangeProvider provider) {
        provider.removeModelChangedListener((IModelChangedListener)this);
    }

    private void initialize() {
        this.operations = new Vector<IModelChangedEvent>();
        this.cursor = -1;
        this.updateActions();
    }

    public boolean isUndoable() {
        return this.cursor >= 0;
    }

    public boolean isRedoable() {
        if (this.operations == null) {
            this.initialize();
        }
        return this.cursor + 1 < this.operations.size();
    }

    public void undo() {
        IModelChangedEvent op = this.getCurrentOperation();
        if (op == null) {
            return;
        }
        this.ignoreChanges = true;
        this.openRelatedPage(op);
        this.execute(op, true);
        --this.cursor;
        this.updateActions();
        this.ignoreChanges = false;
    }

    public void redo() {
        ++this.cursor;
        IModelChangedEvent op = this.getCurrentOperation();
        if (op == null) {
            return;
        }
        this.ignoreChanges = true;
        this.openRelatedPage(op);
        this.execute(op, false);
        this.ignoreChanges = false;
        this.updateActions();
    }

    protected abstract String getPageId(Object var1);

    protected abstract void execute(IModelChangedEvent var1, boolean var2);

    private void openRelatedPage(IModelChangedEvent op) {
        IFormPage newPage;
        IFormPage cpage;
        Object obj = op.getChangedObjects()[0];
        String pageId = this.getPageId(obj);
        if (pageId != null && (cpage = this.editor.getActivePageInstance()) != (newPage = this.editor.findPage(pageId))) {
            this.editor.setActivePage(newPage.getId());
        }
    }

    public void modelChanged(IModelChangedEvent event) {
        if (this.ignoreChanges) {
            return;
        }
        if (event.getChangeType() == 99) {
            this.initialize();
            return;
        }
        this.addOperation(event);
    }

    private IModelChangedEvent getCurrentOperation() {
        if (this.cursor == -1 || this.cursor == this.operations.size()) {
            return null;
        }
        return this.operations.get(this.cursor);
    }

    private IModelChangedEvent getNextOperation() {
        int peekCursor = this.cursor + 1;
        if (peekCursor >= this.operations.size()) {
            return null;
        }
        return this.operations.get(peekCursor);
    }

    private void addOperation(IModelChangedEvent operation) {
        this.operations.add(operation);
        int size = this.operations.size();
        if (size > this.undoLevelLimit) {
            int extra = size - this.undoLevelLimit;
            int i = 0;
            while (i < extra) {
                this.operations.remove(i);
                ++i;
            }
        }
        this.cursor = this.operations.size() - 1;
        this.updateActions();
    }

    public void setActions(IAction undoAction, IAction redoAction) {
        this.undoAction = undoAction;
        this.redoAction = redoAction;
        this.updateActions();
    }

    private void updateActions() {
        if (this.undoAction != null && this.redoAction != null) {
            this.undoAction.setEnabled(this.isUndoable());
            this.undoAction.setText(this.getUndoText());
            this.redoAction.setEnabled(this.isRedoable());
            this.redoAction.setText(this.getRedoText());
        }
    }

    private String getUndoText() {
        IModelChangedEvent op = this.getCurrentOperation();
        if (op == null) {
            return PDEUIMessages.UpdateManager_noUndo;
        }
        return NLS.bind((String)PDEUIMessages.UpdateManager_undo, (Object)this.getOperationText(op));
    }

    private String getRedoText() {
        IModelChangedEvent op = this.getNextOperation();
        if (op == null) {
            return PDEUIMessages.UpdateManager_noRedo;
        }
        return NLS.bind((String)PDEUIMessages.UpdateManager_redo, (Object)this.getOperationText(op));
    }

    private String getOperationText(IModelChangedEvent op) {
        String opText = "";
        switch (op.getChangeType()) {
            case 1: {
                opText = PDEUIMessages.UpdateManager_op_add;
                break;
            }
            case 2: {
                opText = PDEUIMessages.UpdateManager_op_remove;
                break;
            }
            case 3: {
                opText = PDEUIMessages.UpdateManager_op_change;
            }
        }
        return opText;
    }

    public void setUndoLevelLimit(int limit) {
        this.undoLevelLimit = limit;
    }

    public void setIgnoreChanges(boolean ignore) {
        this.ignoreChanges = ignore;
    }
}

