/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.samples;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.equinox.internal.provisional.configurator.Configurator;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProfileRegistry;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.operations.InstallOperation;
import org.eclipse.equinox.p2.operations.ProvisioningJob;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.ui.ProvisioningUI;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.samples.SampleWizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.intro.IIntroSite;
import org.eclipse.ui.intro.config.IIntroAction;
import org.eclipse.ui.intro.config.IIntroURL;
import org.eclipse.ui.intro.config.IntroURLFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShowSampleAction
extends Action
implements IIntroAction {
    private static final String SAMPLE_FEATURE_ID = "org.eclipse.sdk.samples";
    private static final String UPDATE_SITE = "http://www.eclipse.org/pde/samples/site.xml";
    private String sampleId;
    private ProvisioningUI provUI = ProvisioningUI.getDefaultUI();

    public void run(IIntroSite site, Properties params) {
        this.sampleId = params.getProperty("id");
        if (this.sampleId == null) {
            return;
        }
        Runnable r = new Runnable(){

            public void run() {
                if (!ShowSampleAction.this.ensureSampleFeaturePresent()) {
                    return;
                }
                SampleWizard wizard = new SampleWizard();
                try {
                    wizard.setInitializationData(null, "class", ShowSampleAction.this.sampleId);
                    wizard.setSampleEditorNeeded(false);
                    wizard.setSwitchPerspective(false);
                    wizard.setSelectRevealEnabled(false);
                    wizard.setActivitiesEnabled(false);
                    WizardDialog dialog = new WizardDialog(PDEPlugin.getActiveWorkbenchShell(), (IWizard)wizard);
                    dialog.create();
                    if (dialog.open() == 0) {
                        ShowSampleAction.this.switchToSampleStandby(wizard);
                    }
                }
                catch (CoreException e) {
                    PDEPlugin.logException(e);
                }
            }
        };
        Shell currentShell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        currentShell.getDisplay().asyncExec(r);
    }

    private void switchToSampleStandby(SampleWizard wizard) {
        StringBuffer url = new StringBuffer();
        url.append("http://org.eclipse.ui.intro/showStandby?");
        url.append("pluginId=org.eclipse.pde.ui");
        url.append("&");
        url.append("partId=org.eclipse.pde.ui.sampleStandbyPart");
        url.append("&");
        url.append("input=");
        url.append(this.sampleId);
        IIntroURL introURL = IntroURLFactory.createIntroURL((String)url.toString());
        if (introURL != null) {
            introURL.execute();
            this.ensureProperContext(wizard);
        }
    }

    private void ensureProperContext(SampleWizard wizard) {
        IConfigurationElement sample = wizard.getSelection();
        String perspId = sample.getAttribute("perspectiveId");
        if (perspId != null) {
            try {
                wizard.enableActivities();
                PlatformUI.getWorkbench().showPerspective(perspId, PDEPlugin.getActiveWorkbenchWindow());
                wizard.selectReveal(PDEPlugin.getActiveWorkbenchShell());
            }
            catch (WorkbenchException e) {
                PDEPlugin.logException(e);
            }
        }
        this.enableActivities(sample);
    }

    private void enableActivities(IConfigurationElement sample) {
    }

    private boolean ensureSampleFeaturePresent() {
        IProfile profile = this.getProfile();
        if (profile == null) {
            return false;
        }
        if (this.checkFeature(profile)) {
            return true;
        }
        if (MessageDialog.openQuestion((Shell)PDEPlugin.getActiveWorkbenchShell(), (String)PDEUIMessages.ShowSampleAction_msgTitle, (String)PDEUIMessages.ShowSampleAction_msgDesc)) {
            return this.downloadFeature();
        }
        return false;
    }

    private boolean checkFeature(IProfile profile) {
        return !profile.query(this.getSampleFeatureQuery(), null).isEmpty();
    }

    private IProfile getProfile() {
        IProvisioningAgent agent = this.provUI.getSession().getProvisioningAgent();
        if (agent == null) {
            return null;
        }
        IProfileRegistry registry = (IProfileRegistry)agent.getService(IProfileRegistry.SERVICE_NAME);
        if (registry == null) {
            return null;
        }
        return registry.getProfile(this.provUI.getProfileId());
    }

    IQuery<IInstallableUnit> getSampleFeatureQuery() {
        return QueryUtil.createIUQuery((String)SAMPLE_FEATURE_ID);
    }

    private boolean downloadFeature() {
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (String)PDEUIMessages.ShowSampleAction_installing, (int)100);
                    InstallOperation operation = ShowSampleAction.this.createInstallOperation(sub.newChild(10));
                    operation.resolveModal((IProgressMonitor)sub.newChild(20));
                    IStatus status = operation.getResolutionResult();
                    if (status.getSeverity() == 8) {
                        throw new InterruptedException();
                    }
                    if (!status.isOK() && status.getSeverity() != 1) {
                        throw new CoreException(status);
                    }
                    ProvisioningJob job = operation.getProvisioningJob(null);
                    status = job.runModal((IProgressMonitor)sub.newChild(70));
                    if (!status.isOK() && status.getSeverity() != 1) {
                        throw new CoreException(status);
                    }
                    ShowSampleAction.this.applyConfiguration();
                }
                catch (Exception e) {
                    throw new InvocationTargetException(e);
                }
            }
        };
        try {
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(op);
        }
        catch (InvocationTargetException e) {
            PDEPlugin.logException(e);
            return false;
        }
        catch (InterruptedException e) {
            PDEPlugin.logException(e);
        }
        return true;
    }

    protected Collection<IInstallableUnit> findSampleIUs(URI location, SubMonitor monitor) throws ProvisionException {
        IMetadataRepository repository = this.provUI.loadMetadataRepository(location, false, (IProgressMonitor)monitor.newChild(5));
        IQueryResult allSamples = repository.query(this.getSampleFeatureQuery(), (IProgressMonitor)monitor.newChild(5));
        if (allSamples.isEmpty()) {
            throw new ProvisionException(NLS.bind((String)PDEUIMessages.ShowSampleAction_NoSamplesFound, (Object)location.toString()));
        }
        IInstallableUnit toInstall = null;
        for (IInstallableUnit current : allSamples) {
            if (toInstall != null && toInstall.getVersion().compareTo((Object)current.getVersion()) >= 0) continue;
            toInstall = current;
        }
        ArrayList<IInstallableUnit> result = new ArrayList<IInstallableUnit>(1);
        result.add(toInstall);
        return result;
    }

    InstallOperation createInstallOperation(SubMonitor monitor) throws URISyntaxException, ProvisionException {
        URI repositoryLocation = new URI(UPDATE_SITE);
        Collection<IInstallableUnit> sampleIUs = this.findSampleIUs(repositoryLocation, monitor);
        URI[] repos = new URI[]{repositoryLocation};
        InstallOperation operation = this.provUI.getInstallOperation(sampleIUs, repos);
        return operation;
    }

    void applyConfiguration() throws CoreException {
        BundleContext context = PDEPlugin.getDefault().getBundle().getBundleContext();
        ServiceReference reference = context.getServiceReference(Configurator.class.getName());
        Configurator configurator = (Configurator)context.getService(reference);
        try {
            try {
                configurator.applyConfiguration();
            }
            catch (IOException e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.ui", "Unexpected failure applying configuration", (Throwable)e));
            }
        }
        finally {
            context.ungetService(reference);
        }
    }
}

