/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.parser.antlr;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.Stack;
import org.antlr.runtime.BaseRecognizer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.IGrammarAccess;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.UnorderedGroup;
import org.eclipse.xtext.parser.antlr.IUnorderedGroupHelper;

public class UnorderedGroupHelper
implements IUnorderedGroupHelper {
    private Map<UnorderedGroup, State> groupToState = Maps.newHashMap();
    private SortedMap<Integer, IUnorderedGroupHelper.UnorderedGroupState> backtrackingSnapShot = Maps.newTreeMap();
    private BaseRecognizer recognizer;
    private UnorderedGroup[] allGroups;

    @Inject
    public UnorderedGroupHelper(Collector collector) {
        for (UnorderedGroup group : collector.getGroups()) {
            this.configure(group);
        }
        this.allGroups = (UnorderedGroup[])collector.getGroups().toArray((Object[])new UnorderedGroup[collector.getGroups().size()]);
    }

    public void initializeWith(BaseRecognizer recognizer) {
        this.recognizer = recognizer;
    }

    protected BaseRecognizer getRecognizer() {
        return this.recognizer;
    }

    protected void configure(UnorderedGroup group) {
        this.groupToState.put(group, new State(group));
    }

    protected State get(UnorderedGroup group) {
        this.snapShotForBacktracking();
        State result = this.groupToState.get(group);
        if (result == null) {
            throw new IllegalArgumentException("Unexpected group: " + group);
        }
        return result;
    }

    protected void snapShotForBacktracking() {
        int backtrackingLevel = this.getBacktrackingLevel();
        if (backtrackingLevel != 0 || !this.backtrackingSnapShot.isEmpty()) {
            if (backtrackingLevel == 0 || !this.backtrackingSnapShot.isEmpty() && backtrackingLevel < this.backtrackingSnapShot.firstKey()) {
                this.backtrackingSnapShot.values().iterator().next().restore();
                this.backtrackingSnapShot.clear();
                if (backtrackingLevel > 0) {
                    UnorderedGroupStateImpl state = new UnorderedGroupStateImpl(this.allGroups);
                    this.backtrackingSnapShot.put(backtrackingLevel, state);
                }
            } else if (this.backtrackingSnapShot.isEmpty() || backtrackingLevel > this.backtrackingSnapShot.lastKey()) {
                UnorderedGroupStateImpl state = new UnorderedGroupStateImpl(this.allGroups);
                this.backtrackingSnapShot.put(backtrackingLevel, state);
            }
        }
    }

    protected int getBacktrackingLevel() {
        return this.recognizer.getBacktrackingLevel();
    }

    public void enter(UnorderedGroup group) {
        this.get(group).enter();
    }

    public void leave(UnorderedGroup group) {
        this.get(group).leave();
    }

    public boolean canSelect(UnorderedGroup group, int index) {
        return this.get(group).canSelect(index);
    }

    public void select(UnorderedGroup group, int index) {
        this.get(group).select(index);
    }

    public void returnFromSelection(UnorderedGroup group) {
        this.get(group).returnFromSelection();
    }

    public boolean canLeave(UnorderedGroup group) {
        return this.get(group).canLeave();
    }

    public IUnorderedGroupHelper.UnorderedGroupState snapShot(UnorderedGroup ... groups) {
        return new UnorderedGroupStateImpl(groups);
    }

    public String toString() {
        return "UnorderedGroupHelper: " + this.groupToState;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Singleton
    public static class Collector {
        private final ImmutableList<UnorderedGroup> groups;

        @Inject
        public Collector(IGrammarAccess grammarAccess) {
            Grammar grammar = grammarAccess.getGrammar();
            List<ParserRule> parserRules = GrammarUtil.allParserRules(grammar);
            ArrayList groups = Lists.newArrayList();
            for (ParserRule rule : parserRules) {
                TreeIterator iter = rule.eAllContents();
                while (iter.hasNext()) {
                    EObject next = (EObject)iter.next();
                    if (!(next instanceof UnorderedGroup)) continue;
                    groups.add((UnorderedGroup)next);
                }
            }
            this.groups = ImmutableList.copyOf((Collection)groups);
        }

        public ImmutableList<UnorderedGroup> getGroups() {
            return this.groups;
        }
    }

    protected static class Frame {
        protected boolean[] predicate;
        protected int remaining;

        protected Frame() {
        }

        protected Frame(Frame original) {
            this.predicate = (boolean[])original.predicate.clone();
            this.remaining = original.remaining;
        }
    }

    protected static class State {
        private Stack<Frame> frames = new Stack();
        private int alternatives;
        private int mandatoryAlternativeCount;
        private boolean returnTrue = true;
        private boolean[] mandatoryAlternatives;
        private int selected = -1;

        public State(UnorderedGroup group) {
            EList<AbstractElement> elements = group.getElements();
            this.alternatives = elements.size();
            this.mandatoryAlternatives = new boolean[this.alternatives];
            this.mandatoryAlternativeCount = 0;
            int i = 0;
            while (i < this.alternatives) {
                boolean isMandatory;
                boolean bl = isMandatory = !GrammarUtil.isOptionalCardinality((AbstractElement)elements.get(i));
                if (isMandatory) {
                    this.mandatoryAlternatives[i] = true;
                    ++this.mandatoryAlternativeCount;
                }
                ++i;
            }
        }

        protected State(State original) {
            Iterator iter = original.frames.iterator();
            while (iter.hasNext()) {
                Frame copy = new Frame((Frame)iter.next());
                this.frames.push(copy);
            }
            this.alternatives = original.alternatives;
            this.mandatoryAlternativeCount = original.mandatoryAlternativeCount;
            this.returnTrue = original.returnTrue;
            this.mandatoryAlternatives = (boolean[])original.mandatoryAlternatives.clone();
            this.selected = original.selected;
        }

        protected void pushFrame() {
            Frame frame = new Frame();
            frame.predicate = new boolean[this.alternatives];
            frame.remaining = this.mandatoryAlternativeCount;
            this.frames.push(frame);
        }

        public boolean canLeave() {
            if (this.returnTrue) {
                throw new IllegalStateException();
            }
            return this.frames.peek().remaining == 0;
        }

        public void returnFromSelection() {
            this.returnTrue = false;
            this.selected = -1;
        }

        public boolean canSelect(int index) {
            boolean result = this.returnTrue && index != this.selected || !this.frames.peek().predicate[index];
            return result;
        }

        public void select(int index) {
            this.returnTrue = true;
            this.selected = index;
            Frame current = this.frames.peek();
            current.predicate[index] = true;
            if (this.mandatoryAlternatives[index]) {
                --current.remaining;
            }
        }

        public void leave() {
            this.returnTrue = true;
            this.frames.pop();
        }

        public void enter() {
            this.returnTrue = false;
            this.pushFrame();
        }

        public State copy() {
            return new State(this);
        }

        public String toString() {
            if (this.frames.isEmpty()) {
                return "State: []";
            }
            Frame frame = this.frames.peek();
            return "State: " + Arrays.toString(frame.predicate) + " " + frame.remaining + " remaining";
        }
    }

    protected class UnorderedGroupStateImpl
    implements IUnorderedGroupHelper.UnorderedGroupState {
        private Map<UnorderedGroup, State> groupToState = Maps.newHashMap();

        protected UnorderedGroupStateImpl(UnorderedGroup[] groups) {
            UnorderedGroup[] unorderedGroupArray = groups;
            int n = groups.length;
            int n2 = 0;
            while (n2 < n) {
                UnorderedGroup group = unorderedGroupArray[n2];
                State state = (State)UnorderedGroupHelper.this.groupToState.get(group);
                this.groupToState.put(group, state.copy());
                ++n2;
            }
        }

        public void restore() {
            UnorderedGroupHelper.this.groupToState.putAll(this.groupToState);
        }
    }
}

