/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.resource;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ExtensibleURIConverterImpl;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.xtext.resource.ClassloaderClasspathUriResolver;
import org.eclipse.xtext.resource.ClasspathUriResolutionException;
import org.eclipse.xtext.resource.ClasspathUriUtil;
import org.eclipse.xtext.resource.IClasspathUriResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XtextResourceSet
extends ResourceSetImpl {
    private UriChangeListener uriChangeListener = new UriChangeListener();
    private IClasspathUriResolver resolver;
    private Object classpathURIContext;

    protected UriChangeListener getUriChangeListener() {
        return this.uriChangeListener;
    }

    protected void registerURI(Resource resource) {
        Map map = this.getURIResourceMap();
        if (map != null) {
            Resource previous;
            URI normalized;
            URI uri = resource.getURI();
            if (uri != null && !(normalized = this.getURIConverter().normalize(uri)).equals(uri) && (previous = map.put(normalized, resource)) != null && previous != resource) {
                throw new IllegalStateException("A resource with the normalized URI '" + normalized + "' was already registered. The resource with the URI '" + previous + "' is no longer registered with the normalized form.");
            }
            Resource previous2 = map.put(uri, resource);
            if (previous2 != null && previous2 != resource) {
                throw new IllegalStateException("A different resource with the URI '" + uri + "' was already registered.");
            }
        }
    }

    public XtextResourceSet() {
        this.setURIResourceMap(new HashMap());
        this.resources = this.createResourceList();
    }

    protected ResourcesList createResourceList() {
        return new ResourcesList();
    }

    private URI resolveClasspathURI(URI uri) {
        return this.getClasspathUriResolver().resolve(this.getClasspathURIContext(), uri);
    }

    public void addLoadOption(Object key, Object value) {
        this.getLoadOptions().put(key, value);
    }

    public void removeLoadOption(Object key) {
        this.getLoadOptions().remove(key);
    }

    public Resource getResource(URI uri, boolean loadOnDemand) {
        Map map = this.getURIResourceMap();
        if (map == null) {
            return super.getResource(uri, loadOnDemand);
        }
        Resource resource = (Resource)map.get(uri);
        if (resource == null) {
            URI normalizedURI = this.getURIConverter().normalize(uri);
            resource = (Resource)map.get(normalizedURI);
        }
        if (resource != null) {
            if (loadOnDemand && !resource.isLoaded()) {
                this.demandLoadHelper(resource);
            }
            return resource;
        }
        Resource delegatedResource = this.delegatedGetResource(uri, loadOnDemand);
        if (delegatedResource != null) {
            return delegatedResource;
        }
        if (loadOnDemand) {
            resource = this.demandCreateResource(uri);
            if (resource == null) {
                throw new RuntimeException("Cannot create a resource for '" + uri + "'; a registered resource factory is needed");
            }
            this.demandLoadHelper(resource);
            return resource;
        }
        return null;
    }

    public URIConverter getURIConverter() {
        if (this.uriConverter == null) {
            this.uriConverter = new ExtensibleURIConverterImpl(){

                public URI normalize(URI uri) {
                    if (ClasspathUriUtil.isClasspathUri(uri)) {
                        URI result = XtextResourceSet.this.resolveClasspathURI(uri);
                        if (ClasspathUriUtil.isClasspathUri(result)) {
                            throw new ClasspathUriResolutionException(result);
                        }
                        result = super.normalize(result);
                        return result;
                    }
                    return super.normalize(uri);
                }

                public InputStream createInputStream(URI uri, Map<?, ?> options) throws IOException {
                    options = XtextResourceSet.this.addTimeout(options);
                    return super.createInputStream(uri, options);
                }

                public Map<String, ?> contentDescription(URI uri, Map<?, ?> options) throws IOException {
                    options = XtextResourceSet.this.addTimeout(options);
                    return super.contentDescription(uri, options);
                }
            };
        }
        return this.uriConverter;
    }

    protected Map<?, ?> addTimeout(Map<?, ?> options) {
        if (options == null || !options.containsKey("TIMEOUT")) {
            HashMap newOptions = options != null ? new HashMap(options) : new HashMap();
            newOptions.put("TIMEOUT", 500);
            options = newOptions;
        }
        return options;
    }

    public Object getClasspathURIContext() {
        return this.classpathURIContext;
    }

    public void setClasspathURIContext(Object classpathURIContext) {
        this.classpathURIContext = classpathURIContext;
    }

    public IClasspathUriResolver getClasspathUriResolver() {
        if (this.resolver == null) {
            this.resolver = new ClassloaderClasspathUriResolver();
        }
        return this.resolver;
    }

    public void setClasspathUriResolver(IClasspathUriResolver resolver) {
        this.resolver = resolver;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ResourcesList
    extends ResourceSetImpl.ResourcesEList<Resource> {
        protected ResourcesList() {
            super((ResourceSetImpl)XtextResourceSet.this);
        }

        protected NotificationChain inverseAdd(Resource resource, NotificationChain notifications) {
            NotificationChain chain = super.inverseAdd((Object)resource, notifications);
            resource.eAdapters().add((Object)XtextResourceSet.this.getUriChangeListener());
            XtextResourceSet.this.registerURI(resource);
            return chain;
        }

        protected NotificationChain inverseRemove(Resource resource, NotificationChain notifications) {
            NotificationChain inverseRemove = super.inverseRemove((Object)resource, notifications);
            resource.eAdapters().remove((Object)XtextResourceSet.this.getUriChangeListener());
            return inverseRemove;
        }

        protected void doClear() {
            super.doClear();
            XtextResourceSet.this.getURIResourceMap().clear();
        }
    }

    protected class UriChangeListener
    extends AdapterImpl {
        protected UriChangeListener() {
        }

        public void notifyChanged(Notification notification) {
            Map map = XtextResourceSet.this.getURIResourceMap();
            if (map != null && notification.getFeatureID(Resource.class) == 1 && notification.getNotifier() instanceof Resource) {
                URI oldNormalized;
                URI oldOne = (URI)notification.getOldValue();
                map.remove(oldOne);
                if (oldOne != null && !oldOne.equals(oldNormalized = XtextResourceSet.this.getURIConverter().normalize(oldOne))) {
                    map.remove(oldNormalized);
                }
                Resource resource = (Resource)notification.getNotifier();
                XtextResourceSet.this.registerURI(resource);
            }
            super.notifyChanged(notification);
        }
    }
}

