/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.util;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.xbase.typesystem.references.ITypeReferenceOwner;
import org.eclipse.xtext.xbase.typesystem.references.LightweightBoundTypeArgument;
import org.eclipse.xtext.xbase.typesystem.references.LightweightMergedBoundTypeArgument;
import org.eclipse.xtext.xbase.typesystem.references.ParameterizedTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.UnboundTypeReference;
import org.eclipse.xtext.xbase.typesystem.util.AbstractTypeReferencePairWalker;
import org.eclipse.xtext.xbase.typesystem.util.BoundTypeArgumentSource;
import org.eclipse.xtext.xbase.typesystem.util.DeferredTypeParameterHintCollector;
import org.eclipse.xtext.xbase.typesystem.util.TypeParameterSubstitutor;
import org.eclipse.xtext.xbase.typesystem.util.UnboundTypeParameterPreservingSubstitutor;
import org.eclipse.xtext.xbase.typesystem.util.VarianceInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NonNullByDefault
public class ExpectationTypeParameterHintCollector
extends DeferredTypeParameterHintCollector {
    public ExpectationTypeParameterHintCollector(ITypeReferenceOwner owner) {
        super(owner);
    }

    @Override
    protected TypeParameterSubstitutor<?> createTypeParameterSubstitutor(Map<JvmTypeParameter, LightweightMergedBoundTypeArgument> mapping) {
        return new UnboundTypeParameterPreservingSubstitutor(mapping, this.getOwner());
    }

    @Override
    protected AbstractTypeReferencePairWalker.ParameterizedTypeReferenceTraverser createParameterizedTypeReferenceTraverser() {
        return new DeferredParameterizedTypeReferenceTraverser();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class DeferredParameterizedTypeReferenceTraverser
    extends AbstractTypeReferencePairWalker.ParameterizedTypeReferenceTraverser {
        protected DeferredParameterizedTypeReferenceTraverser() {
        }

        @Override
        public void doVisitUnboundTypeReference(UnboundTypeReference reference, ParameterizedTypeReference declaration) {
            boolean constraintSeen = false;
            boolean constraintsMatch = true;
            boolean othersSeen = false;
            if (reference.getTypeParameter() != declaration.getType()) {
                List<LightweightBoundTypeArgument> hints = reference.getAllHints();
                int i = 0;
                while (i < hints.size()) {
                    LightweightBoundTypeArgument hint = hints.get(i);
                    if (hint.getSource() == BoundTypeArgumentSource.CONSTRAINT) {
                        constraintSeen = true;
                        ExpectationTypeParameterHintCollector.this.outerVisit(hint.getTypeReference(), declaration, (Object)hint.getSource(), hint.getDeclaredVariance(), hint.getActualVariance());
                        if (constraintsMatch && !hint.getTypeReference().isAssignableFrom(declaration)) {
                            constraintsMatch = false;
                        }
                    } else {
                        othersSeen = true;
                    }
                    ++i;
                }
            } else if (ExpectationTypeParameterHintCollector.this.getOwner().getDeclaredTypeParameters().contains(reference.getTypeParameter())) {
                reference.acceptHint(declaration, BoundTypeArgumentSource.RESOLVED, this, VarianceInfo.INVARIANT, VarianceInfo.INVARIANT);
                return;
            }
            if (constraintSeen && constraintsMatch && !othersSeen) {
                reference.acceptHint(declaration, BoundTypeArgumentSource.RESOLVED, this, VarianceInfo.INVARIANT, VarianceInfo.INVARIANT);
            } else if (!constraintSeen && !reference.internalIsResolved() && declaration.isResolved() && !ExpectationTypeParameterHintCollector.this.getOwner().isResolved(reference.getHandle()) && reference.canResolveTo(declaration)) {
                reference.acceptHint(declaration, BoundTypeArgumentSource.RESOLVED, this, VarianceInfo.INVARIANT, VarianceInfo.INVARIANT);
            } else {
                reference.tryResolve();
                if (reference.internalIsResolved()) {
                    ExpectationTypeParameterHintCollector.this.outerVisit(reference, declaration);
                } else {
                    ExpectationTypeParameterHintCollector.this.addHint(reference, declaration);
                }
            }
        }

        @Override
        protected boolean shouldProcessInContextOf(JvmTypeParameter declaredTypeParameter, Set<JvmTypeParameter> boundParameters, Set<JvmTypeParameter> visited) {
            if (ExpectationTypeParameterHintCollector.this.getOwner().getDeclaredTypeParameters().contains(declaredTypeParameter)) {
                return true;
            }
            return !boundParameters.contains(declaredTypeParameter) || visited.add(declaredTypeParameter);
        }
    }
}

