/*
 * Decompiled with CFR 0.152.
 */
package org.jabylon.war;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.FilterRegistration;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRegistration;
import javax.servlet.SessionCookieConfig;
import javax.servlet.SessionTrackingMode;
import javax.servlet.descriptor.JspConfigDescriptor;

class CustomServletContext
implements ServletContext {
    private ServletContext delegate;
    private Set<String> replacementPaths;
    private File launchProps;

    public CustomServletContext(ServletContext delegate, Properties prop) {
        this.delegate = delegate;
        this.replacementPaths = new HashSet<String>();
        this.replacementPaths.add("/WEB-INF/eclipse/configuration/launch.ini");
        this.replacementPaths.add("/WEB-INF/eclipse/launch.ini");
        try {
            this.launchProps = File.createTempFile("launch", "ini");
            this.launchProps.deleteOnExit();
            FileOutputStream out = new FileOutputStream(this.launchProps);
            prop.store(out, null);
            out.close();
        }
        catch (IOException e) {
            this.log("Failed to store launch properties", e);
        }
    }

    public URL getResource(String path) throws MalformedURLException {
        if (this.replacementPaths.contains(path)) {
            this.log("Serving path: " + path);
            return this.launchProps.toURI().toURL();
        }
        return this.delegate.getResource(path);
    }

    public InputStream getResourceAsStream(String path) {
        if (this.replacementPaths.contains(path)) {
            this.log("Serving path: " + path);
            try {
                return this.getResource(path).openStream();
            }
            catch (MalformedURLException e) {
                this.log("Failed to server replacement launch.ini", e);
            }
            catch (IOException e) {
                this.log("Failed to server replacement launch.ini", e);
            }
        }
        return this.delegate.getResourceAsStream(path);
    }

    public String getContextPath() {
        return this.delegate.getContextPath();
    }

    public ServletContext getContext(String uripath) {
        return this.delegate.getContext(uripath);
    }

    public int getMajorVersion() {
        return this.delegate.getMajorVersion();
    }

    public int getMinorVersion() {
        return this.delegate.getMinorVersion();
    }

    public int getEffectiveMajorVersion() {
        return this.delegate.getEffectiveMajorVersion();
    }

    public int getEffectiveMinorVersion() {
        return this.delegate.getEffectiveMinorVersion();
    }

    public String getMimeType(String file) {
        return this.delegate.getMimeType(file);
    }

    public Set<String> getResourcePaths(String path) {
        return this.delegate.getResourcePaths(path);
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        return this.delegate.getRequestDispatcher(path);
    }

    public RequestDispatcher getNamedDispatcher(String name) {
        return this.delegate.getNamedDispatcher(name);
    }

    public Servlet getServlet(String name) throws ServletException {
        return this.delegate.getServlet(name);
    }

    public Enumeration<Servlet> getServlets() {
        return this.delegate.getServlets();
    }

    public Enumeration<String> getServletNames() {
        return this.delegate.getServletNames();
    }

    public void log(String msg) {
        this.delegate.log(msg);
    }

    public void log(Exception exception, String msg) {
        this.delegate.log(exception, msg);
    }

    public void log(String message, Throwable throwable) {
        this.delegate.log(message, throwable);
    }

    public String getRealPath(String path) {
        return this.delegate.getRealPath(path);
    }

    public String getServerInfo() {
        return this.delegate.getServerInfo();
    }

    public String getInitParameter(String name) {
        return this.delegate.getInitParameter(name);
    }

    public Enumeration<String> getInitParameterNames() {
        return this.delegate.getInitParameterNames();
    }

    public boolean setInitParameter(String name, String value) {
        return this.delegate.setInitParameter(name, value);
    }

    public Object getAttribute(String name) {
        return this.delegate.getAttribute(name);
    }

    public Enumeration<String> getAttributeNames() {
        return this.delegate.getAttributeNames();
    }

    public void setAttribute(String name, Object object) {
        this.delegate.setAttribute(name, object);
    }

    public void removeAttribute(String name) {
        this.delegate.removeAttribute(name);
    }

    public String getServletContextName() {
        return this.delegate.getServletContextName();
    }

    public ServletRegistration.Dynamic addServlet(String servletName, String className) {
        return this.delegate.addServlet(servletName, className);
    }

    public ServletRegistration.Dynamic addServlet(String servletName, Servlet servlet) {
        return this.delegate.addServlet(servletName, servlet);
    }

    public ServletRegistration.Dynamic addServlet(String servletName, Class<? extends Servlet> servletClass) {
        return this.delegate.addServlet(servletName, servletClass);
    }

    public <T extends Servlet> T createServlet(Class<T> clazz) throws ServletException {
        return (T)this.delegate.createServlet(clazz);
    }

    public ServletRegistration getServletRegistration(String servletName) {
        return this.delegate.getServletRegistration(servletName);
    }

    public Map<String, ? extends ServletRegistration> getServletRegistrations() {
        return this.delegate.getServletRegistrations();
    }

    public FilterRegistration.Dynamic addFilter(String filterName, String className) {
        return this.delegate.addFilter(filterName, className);
    }

    public FilterRegistration.Dynamic addFilter(String filterName, Filter filter) {
        return this.delegate.addFilter(filterName, filter);
    }

    public FilterRegistration.Dynamic addFilter(String filterName, Class<? extends Filter> filterClass) {
        return this.delegate.addFilter(filterName, filterClass);
    }

    public <T extends Filter> T createFilter(Class<T> clazz) throws ServletException {
        return (T)this.delegate.createFilter(clazz);
    }

    public FilterRegistration getFilterRegistration(String filterName) {
        return this.delegate.getFilterRegistration(filterName);
    }

    public Map<String, ? extends FilterRegistration> getFilterRegistrations() {
        return this.delegate.getFilterRegistrations();
    }

    public SessionCookieConfig getSessionCookieConfig() {
        return this.delegate.getSessionCookieConfig();
    }

    public void setSessionTrackingModes(Set<SessionTrackingMode> sessionTrackingModes) {
        this.delegate.setSessionTrackingModes(sessionTrackingModes);
    }

    public Set<SessionTrackingMode> getDefaultSessionTrackingModes() {
        return this.delegate.getDefaultSessionTrackingModes();
    }

    public Set<SessionTrackingMode> getEffectiveSessionTrackingModes() {
        return this.delegate.getEffectiveSessionTrackingModes();
    }

    public void addListener(String className) {
        this.delegate.addListener(className);
    }

    public <T extends EventListener> void addListener(T t) {
        this.delegate.addListener(t);
    }

    public void addListener(Class<? extends EventListener> listenerClass) {
        this.delegate.addListener(listenerClass);
    }

    public <T extends EventListener> T createListener(Class<T> clazz) throws ServletException {
        return (T)this.delegate.createListener(clazz);
    }

    public JspConfigDescriptor getJspConfigDescriptor() {
        return this.delegate.getJspConfigDescriptor();
    }

    public ClassLoader getClassLoader() {
        return this.delegate.getClassLoader();
    }

    public void declareRoles(String ... roleNames) {
        this.delegate.declareRoles(roleNames);
    }

    public boolean equals(Object obj) {
        return this.delegate.equals(obj);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }
}

