/*
 * Decompiled with CFR 0.152.
 */
package org.jabylon.war;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.servlet.FilterConfig;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import org.eclipse.equinox.servletbridge.BridgeFilter;
import org.jabylon.war.CustomServletConfig;

public class JabylonFilter
extends BridgeFilter {
    private static final long serialVersionUID = 7535666663439525997L;
    private ServletConfig servletConfig;
    private Properties launchProperties = new Properties();
    private String jabylonHome;
    private FilterConfig filterConfig;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.filterConfig = filterConfig;
        this.internalInit();
        super.init(filterConfig);
    }

    private void internalInit() {
        File homeDir = new File(new File(System.getProperty("user.home")), "jabylon");
        this.jabylonHome = System.getProperty("JABYLON_HOME", homeDir.getAbsolutePath());
        this.launchProperties.put("JABYLON_HOME", this.jabylonHome);
        this.launchProperties.put("osgi.instance.area", homeDir.toURI().toString());
        this.launchProperties.put("osgi.configuration.area", new File(homeDir, "configuration").toURI().toString());
        this.launchProperties.put("osgi.clean", "true");
        System.getProperties().putAll((Map<?, ?>)this.launchProperties);
        this.copyResources("/WEB-INF/eclipse/configuration/", new File(homeDir, "configuration"));
    }

    private void copyResources(String source, File target) {
        if (source.endsWith("/")) {
            target.mkdirs();
            Set paths = this.getServletContext().getResourcePaths(source);
            for (String string : paths) {
                this.copyResources(string, new File(target, string.substring(source.length())));
            }
        } else {
            if (target.exists()) {
                return;
            }
            InputStream stream = this.getServletContext().getResourceAsStream(source);
            FileOutputStream out = null;
            try {
                try {
                    out = new FileOutputStream(target);
                    byte[] buffer = new byte[1024];
                    int read = 0;
                    while (read != -1) {
                        out.write(buffer, 0, read);
                        read = stream.read(buffer);
                    }
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                    try {
                        if (stream != null) {
                            stream.close();
                        }
                        if (out != null) {
                            out.close();
                        }
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    try {
                        if (stream != null) {
                            stream.close();
                        }
                        if (out != null) {
                            out.close();
                        }
                    }
                    catch (IOException e3) {
                        e3.printStackTrace();
                    }
                }
            }
            finally {
                try {
                    if (stream != null) {
                        stream.close();
                    }
                    if (out != null) {
                        out.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public ServletConfig getServletConfig() {
        if (this.servletConfig == null) {
            this.servletConfig = new CustomServletConfig(this.filterConfig, this.launchProperties);
        }
        return this.servletConfig;
    }
}

