/*
 * Decompiled with CFR 0.152.
 */
package org.jabylon.resources.diff;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.jabylon.properties.PropertiesPackage;
import org.jabylon.properties.Property;
import org.jabylon.properties.PropertyFile;
import org.jabylon.resources.diff.CustomNotification;

public class PropertyDifferentiator {
    private PropertyFile original;

    public PropertyDifferentiator(PropertyFile original) {
        this.original = original;
    }

    public List<Notification> diff(PropertyFile modified) {
        Map<String, Property> orignalProperties = this.buildMap(this.original);
        ArrayList<Notification> noticiations = new ArrayList<Notification>();
        this.computeStructuralDiff(orignalProperties, modified, noticiations);
        return noticiations;
    }

    private void computeStructuralDiff(Map<String, Property> orignalProperties, PropertyFile modified, List<Notification> noticiations) {
        ENotificationImpl notification;
        ArrayList<Property> additions = new ArrayList<Property>();
        ArrayList<Property> removals = new ArrayList<Property>();
        for (Property prop : modified.getProperties()) {
            Property originalProperty = orignalProperties.get(prop.getKey());
            if (originalProperty == null) {
                additions.add(prop);
                continue;
            }
            orignalProperties.remove(prop.getKey());
            Notification change = this.computeDiff(originalProperty, prop);
            if (change == null) continue;
            noticiations.add(change);
        }
        removals.addAll(orignalProperties.values());
        if (!additions.isEmpty()) {
            notification = new ENotificationImpl((InternalEObject)modified, 5, (EStructuralFeature)PropertiesPackage.Literals.PROPERTY_FILE__PROPERTIES, null, additions);
            noticiations.add((Notification)notification);
        }
        if (!removals.isEmpty()) {
            notification = new ENotificationImpl((InternalEObject)modified, 5, (EStructuralFeature)PropertiesPackage.Literals.PROPERTY_FILE__PROPERTIES, removals, null);
            noticiations.add((Notification)notification);
        }
    }

    private Notification computeDiff(Property orignalPropertery, Property modifiedProperty) {
        if (orignalPropertery.getValue() == null && modifiedProperty.getValue() == null) {
            return null;
        }
        if (orignalPropertery.getValue() == null && modifiedProperty.getValue() != null) {
            return new CustomNotification(1, null, modifiedProperty.getValue(), modifiedProperty);
        }
        if (modifiedProperty.getValue() == null && orignalPropertery.getValue() != null) {
            return new CustomNotification(2, orignalPropertery.getValue(), null, modifiedProperty);
        }
        if (modifiedProperty.getValue().equals(orignalPropertery.getValue())) {
            return null;
        }
        return new CustomNotification(1, orignalPropertery.getValue(), modifiedProperty.getValue(), modifiedProperty);
    }

    private Map<String, Property> buildMap(PropertyFile file) {
        HashMap<String, Property> properties = new HashMap<String, Property>(file.getProperties().size());
        for (Property property : file.getProperties()) {
            properties.put(property.getKey(), property);
        }
        return properties;
    }
}

