/*
 * Decompiled with CFR 0.152.
 */
package org.jabylon.resources.persistence.internal;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.Weigher;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.Service;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.common.CDOCommonSession;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.net4j.CDONet4jSession;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.util.CommitException;
import org.eclipse.emf.cdo.util.ObjectNotFoundException;
import org.eclipse.emf.cdo.view.CDOAdapterPolicy;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.jabylon.cdo.connector.RepositoryConnector;
import org.jabylon.properties.Project;
import org.jabylon.properties.ProjectLocale;
import org.jabylon.properties.ProjectVersion;
import org.jabylon.properties.PropertiesPackage;
import org.jabylon.properties.PropertyFile;
import org.jabylon.properties.PropertyFileDescriptor;
import org.jabylon.properties.PropertyType;
import org.jabylon.properties.Workspace;
import org.jabylon.properties.util.PropertiesResourceImpl;
import org.jabylon.resources.changes.PropertiesListener;
import org.jabylon.resources.diff.PropertyDifferentiator;
import org.jabylon.resources.persistence.PropertyPersistenceService;
import org.jabylon.resources.persistence.internal.PropertyFileCacheLoader;
import org.jabylon.resources.persistence.internal.PropertySizeWeigher;
import org.jabylon.resources.persistence.internal.PropertyTuple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Service(value={PropertyPersistenceService.class})
public class PropertiesPersistenceServiceImpl
implements PropertyPersistenceService,
Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(PropertiesPersistenceServiceImpl.class);
    @Reference(policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.OPTIONAL_MULTIPLE, referenceInterface=PropertiesListener.class, bind="addPropertiesListener", unbind="removePropertiesListener")
    private List<PropertiesListener> listeners = new CopyOnWriteArrayList<PropertiesListener>();
    private BlockingQueue<PropertyTuple> queue;
    private static Logger logger = LoggerFactory.getLogger(PropertiesPersistenceServiceImpl.class);
    @Reference
    private RepositoryConnector repositoryConnector;
    private Workspace workspace;
    private Thread runner;
    private LoadingCache<CDOID, PropertyFile> cache;
    private boolean active;

    @Activate
    public void activate() {
        this.queue = new ArrayBlockingQueue<PropertyTuple>(50);
        this.runner = new Thread((Runnable)this, "Properties Persistence Service");
        this.runner.setDaemon(true);
        this.runner.start();
        this.active = true;
    }

    @Deactivate
    public void deactivate() {
        this.shutdownQueue();
        this.listeners.clear();
        this.queue = null;
        this.runner.interrupt();
        this.runner = null;
    }

    private void shutdownQueue() {
        this.active = false;
        int size = this.queue.size();
        logger.info("Shutting down. Queuesize is {}", (Object)size);
        while (this.queue.size() > 0) {
            logger.info("Shutting down. Remaining Queuesize is {}", (Object)this.queue.size());
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                logger.info("Interrupted while draining queue. Exiting");
            }
        }
    }

    public void bindRepositoryConnector(RepositoryConnector repositoryConnector) {
        this.repositoryConnector = repositoryConnector;
        this.hookListener(repositoryConnector);
    }

    private void hookListener(RepositoryConnector repositoryConnector) {
        CDONet4jSession session = repositoryConnector.createSession();
        session.options().setPassiveUpdateMode(CDOCommonSession.Options.PassiveUpdateMode.ADDITIONS);
        CDOView view = session.openView();
        view.options().addChangeSubscriptionPolicy(CDOAdapterPolicy.ALL);
        CDOResource resource = view.getResource("workspace");
        this.workspace = (Workspace)resource.getContents().get(0);
        this.cache = CacheBuilder.newBuilder().expireAfterAccess(10L, TimeUnit.MINUTES).concurrencyLevel(5).maximumWeight(20000L).weigher((Weigher)new PropertySizeWeigher()).recordStats().build((CacheLoader)new PropertyFileCacheLoader(this.workspace.cdoView()));
        new Thread(new Runnable(){

            @Override
            public void run() {
                long time = System.currentTimeMillis();
                PropertiesPersistenceServiceImpl.this.workspace.eAdapters().add((Object)new ListeningAdapter());
                LOGGER.info("Installed EContentAdapter in {} seconds", (Object)((System.currentTimeMillis() - time) / 1000L));
            }
        }, "Install Persistence Listener").start();
    }

    public void unbindRepositoryConnector(RepositoryConnector repositoryConnector) {
        this.repositoryConnector = null;
        if (this.workspace != null) {
            CDOView view = this.workspace.cdoView();
            CDOSession session = view.getSession();
            LifecycleUtil.deactivate((Object)view);
            LifecycleUtil.deactivate((Object)session);
            Object var3_3 = null;
        }
    }

    @Override
    public void saveProperties(PropertyFileDescriptor descriptor, PropertyFile file) {
        this.saveProperties(descriptor, file, false);
    }

    @Override
    public void saveProperties(PropertyFileDescriptor descriptor, PropertyFile file, boolean autoTranslate) {
        if (!this.active) {
            logger.error("Received save request while not active");
            throw new IllegalStateException("The PropertiesPersistanceService is deactivated");
        }
        try {
            PropertyFileDescriptor adaptedDescriptor = (PropertyFileDescriptor)this.workspace.cdoView().getObject((EObject)descriptor);
            PropertyFile writeCopy = this.createCopy(file);
            this.queue.put(new PropertyTuple(adaptedDescriptor, writeCopy, autoTranslate));
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted while trying to save " + descriptor.fullPath(), e);
        }
    }

    private PropertyFile createCopy(PropertyFile file) {
        return (PropertyFile)EcoreUtil.copy((EObject)file);
    }

    @Override
    public void addPropertiesListener(PropertiesListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removePropertiesListener(PropertiesListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void run() {
        CDOTransaction transaction = null;
        try {
            try {
                while (true) {
                    PropertyTuple tuple = this.queue.take();
                    try {
                        if (transaction == null) {
                            transaction = this.workspace.cdoView().getSession().openTransaction();
                        }
                        PropertyFileDescriptor descriptor = (PropertyFileDescriptor)transaction.getObject((EObject)tuple.getDescriptor());
                        PropertyFile file = tuple.getFile();
                        URI path = descriptor.absolutPath();
                        Map<String, Object> options = this.createOptions(descriptor);
                        if (new File(path.toFileString()).exists()) {
                            PropertyFile original = descriptor.loadProperties();
                            PropertyDifferentiator differentiator = new PropertyDifferentiator(original);
                            PropertiesResourceImpl resource = new PropertiesResourceImpl(path);
                            resource.getContents().add((Object)file);
                            resource.save(options);
                            descriptor.setKeys(resource.getSavedProperties());
                            descriptor.updatePercentComplete();
                            transaction.commit();
                            List<Notification> diff = differentiator.diff(file);
                            this.firePropertiesChanges(descriptor, diff, tuple.isAutoSync());
                            continue;
                        }
                        PropertiesResourceImpl resource = new PropertiesResourceImpl(path);
                        resource.getContents().add((Object)file);
                        resource.save(options);
                        descriptor.setKeys(resource.getSavedProperties());
                        descriptor.updatePercentComplete();
                        transaction.commit();
                        this.firePropertiesAdded(descriptor, tuple.isAutoSync());
                    }
                    catch (IOException e) {
                        logger.error("Exception while processing " + tuple, (Throwable)e);
                    }
                    catch (CommitException e) {
                        logger.error("failed to commit while processing " + tuple, (Throwable)e);
                        transaction.close();
                        transaction = null;
                    }
                }
            }
            catch (InterruptedException e) {
                logger.warn("Received Interrupt. Shutting down...");
                if (this.queue != null) {
                    this.queue.clear();
                }
                if (transaction != null) {
                    transaction.close();
                }
            }
        }
        catch (Throwable throwable) {
            if (this.queue != null) {
                this.queue.clear();
            }
            if (transaction != null) {
                transaction.close();
            }
            throw throwable;
        }
    }

    private Map<String, Object> createOptions(PropertyFileDescriptor descriptor) {
        HashMap<String, Object> options = new HashMap<String, Object>();
        if (descriptor.getProjectLocale() != null && descriptor.getProjectLocale().getParent() != null && ((ProjectVersion)descriptor.getProjectLocale().getParent()).getParent() != null) {
            ProjectVersion version = (ProjectVersion)descriptor.getProjectLocale().getParent();
            Project project = (Project)version.getParent();
            PropertyType propertyType = project.getPropertyType();
            options.put("file.mode", propertyType);
        }
        return options;
    }

    private void firePropertiesAdded(PropertyFileDescriptor descriptor, boolean autoSync) {
        for (PropertiesListener listener : this.listeners) {
            listener.propertyFileAdded(descriptor, autoSync);
        }
    }

    private void firePropertiesDeleted(PropertyFileDescriptor descriptor, boolean autoSync) {
        for (PropertiesListener listener : this.listeners) {
            listener.propertyFileDeleted(descriptor, autoSync);
        }
    }

    private void firePropertiesChanges(PropertyFileDescriptor descriptor, List<Notification> diff, boolean autoSync) {
        for (PropertiesListener listener : this.listeners) {
            listener.propertyFileModified(descriptor, diff, autoSync);
        }
    }

    @Override
    public PropertyFile loadProperties(PropertyFileDescriptor descriptor) throws ExecutionException {
        return this.loadProperties(descriptor.cdoID());
    }

    @Override
    public PropertyFile loadProperties(CDOID descriptor) throws ExecutionException {
        return (PropertyFile)this.cache.get((Object)descriptor);
    }

    @Override
    public void clearCache() {
        this.cache.invalidateAll();
    }

    private final class ListeningAdapter
    extends EContentAdapter {
        private ListeningAdapter() {
        }

        public void notifyChanged(Notification notification) {
            Object object;
            super.notifyChanged(notification);
            if (notification.getNotifier() instanceof ProjectVersion) {
                ProjectLocale locale;
                ProjectVersion version = (ProjectVersion)notification.getNotifier();
                if (notification.getEventType() == 3) {
                    object = notification.getNewValue();
                    if (object instanceof ProjectLocale) {
                        locale = (ProjectLocale)object;
                        EList descriptors = locale.getDescriptors();
                        for (PropertyFileDescriptor propertyFileDescriptor : descriptors) {
                            PropertiesPersistenceServiceImpl.this.firePropertiesAdded(propertyFileDescriptor, false);
                        }
                    }
                } else if (notification.getEventType() == 4) {
                    object = notification.getOldValue();
                    if (object instanceof ProjectLocale) {
                        locale = (ProjectLocale)object;
                        EList descriptors = locale.getDescriptors();
                    }
                } else if (notification.getEventType() == 1 && (object = notification.getNewValue()) instanceof ProjectLocale) {
                    locale = (ProjectLocale)object;
                    EList descriptors = locale.getDescriptors();
                    for (PropertyFileDescriptor propertyFileDescriptor : descriptors) {
                        PropertiesPersistenceServiceImpl.this.firePropertiesAdded(propertyFileDescriptor, false);
                    }
                }
            }
            if (notification.getNotifier() instanceof ProjectLocale) {
                PropertyFileDescriptor descriptor;
                ProjectLocale locale = (ProjectLocale)notification.getNotifier();
                if (notification.getEventType() == 3 && PropertiesPackage.Literals.PROJECT_LOCALE__DESCRIPTORS == notification.getFeature() && (object = notification.getNewValue()) instanceof PropertyFileDescriptor) {
                    descriptor = (PropertyFileDescriptor)object;
                    PropertiesPersistenceServiceImpl.this.firePropertiesAdded(descriptor, false);
                }
                if (notification.getEventType() == 4 && PropertiesPackage.Literals.PROJECT_LOCALE__DESCRIPTORS == notification.getFeature() && (object = notification.getOldValue()) instanceof PropertyFileDescriptor) {
                    descriptor = (PropertyFileDescriptor)object;
                    PropertiesPersistenceServiceImpl.this.firePropertiesDeleted(descriptor, false);
                }
            }
            if (notification.getNotifier() instanceof PropertyFileDescriptor) {
                PropertyFileDescriptor descriptor = (PropertyFileDescriptor)notification.getNotifier();
                if (notification.getEventType() == 111) {
                    PropertiesPersistenceServiceImpl.this.firePropertiesDeleted(descriptor, false);
                }
            }
        }

        protected void removeAdapter(Notifier notifier) {
            CDOObject o;
            if (notifier instanceof CDOObject && !(o = (CDOObject)notifier).cdoInvalid()) {
                super.removeAdapter(notifier);
            }
        }

        protected void handleContainment(Notification notification) {
            switch (notification.getEventType()) {
                case 4: {
                    Object oldValue = notification.getOldValue();
                    if (oldValue instanceof Notifier) {
                        Notifier notifier = (Notifier)oldValue;
                        this.removeAdapter(notifier);
                        break;
                    }
                    if (!(oldValue instanceof CDOID)) break;
                    CDOID id = (CDOID)oldValue;
                    this.removeAdapter((Notifier)PropertiesPersistenceServiceImpl.this.workspace.cdoView().getObject(id));
                    break;
                }
                case 6: {
                    Collection oldValues = (Collection)notification.getOldValue();
                    for (Object oldContentValue : oldValues) {
                        if (oldContentValue instanceof Notifier) {
                            Notifier notifier = (Notifier)oldContentValue;
                            this.removeAdapter(notifier);
                            continue;
                        }
                        if (!(oldContentValue instanceof CDOID)) continue;
                        CDOID id = (CDOID)oldContentValue;
                        try {
                            this.removeAdapter((Notifier)PropertiesPersistenceServiceImpl.this.workspace.cdoView().getObject(id));
                        }
                        catch (ObjectNotFoundException e) {
                            logger.warn("REMOVE_MANY object ID not found: " + notification, (Throwable)e);
                        }
                    }
                    break;
                }
                default: {
                    super.handleContainment(notification);
                }
            }
        }
    }
}

