/*
 * Decompiled with CFR 0.152.
 */
package org.jabylon.cdo.server;

import java.io.File;
import java.util.HashMap;
import javax.sql.DataSource;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.net4j.CDONet4jSession;
import org.eclipse.emf.cdo.net4j.CDONet4jSessionConfiguration;
import org.eclipse.emf.cdo.net4j.CDONet4jUtil;
import org.eclipse.emf.cdo.server.CDOServerUtil;
import org.eclipse.emf.cdo.server.IRepository;
import org.eclipse.emf.cdo.server.IStore;
import org.eclipse.emf.cdo.server.db.CDODBUtil;
import org.eclipse.emf.cdo.server.db.IDBStore;
import org.eclipse.emf.cdo.server.db.mapping.IMappingStrategy;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.util.CDOUtil;
import org.eclipse.emf.cdo.util.CommitException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.net4j.acceptor.IAcceptor;
import org.eclipse.net4j.connector.IConnector;
import org.eclipse.net4j.db.DBUtil;
import org.eclipse.net4j.db.IDBAdapter;
import org.eclipse.net4j.db.IDBConnectionProvider;
import org.eclipse.net4j.db.h2.H2Adapter;
import org.eclipse.net4j.jvm.IJVMAcceptor;
import org.eclipse.net4j.jvm.IJVMConnector;
import org.eclipse.net4j.jvm.JVMUtil;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.container.IPluginContainer;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.h2.jdbcx.JdbcDataSource;
import org.jabylon.cdo.server.ServerConstants;
import org.jabylon.db.migration.DBMigrator;
import org.jabylon.properties.PropertiesFactory;
import org.jabylon.properties.PropertiesPackage;
import org.jabylon.properties.Workspace;
import org.jabylon.users.Permission;
import org.jabylon.users.Role;
import org.jabylon.users.User;
import org.jabylon.users.UserManagement;
import org.jabylon.users.UsersFactory;
import org.jabylon.users.UsersPackage;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Activator
implements BundleActivator {
    private static Activator plugin;
    public static final String PLUGIN_ID = "org.jabylon.cdo.server";
    private IJVMAcceptor acceptor = null;
    private IRepository repository = null;
    private static final Logger logger;

    public static Activator getDefault() {
        return plugin;
    }

    public void start(BundleContext context) throws Exception {
        plugin = this;
        this.initialize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initialize() throws CommitException {
        this.startRepository();
        CDONet4jSession session = this.createSession();
        CDOTransaction transaction = session.openTransaction();
        try {
            this.initializeWorkspace(transaction);
            this.initializeUserManagement(transaction);
            FrameworkUtil.getBundle(this.getClass()).getBundleContext().registerService(IAcceptor.class, (Object)this.acceptor, null);
        }
        catch (CommitException e) {
            logger.error("Failed to initialize repository", (Throwable)e);
        }
        finally {
            transaction.close();
            session.close();
        }
    }

    private void initializeUserManagement(CDOTransaction transaction) throws CommitException {
        UserManagement userManagement;
        CDOResource resource = transaction.getOrCreateResource("users");
        if (resource.getContents().isEmpty()) {
            userManagement = UsersFactory.eINSTANCE.createUserManagement();
            userManagement.getUsers().add((Object)this.getAdminUser());
            userManagement.getUsers().add((Object)this.getAnonymousUser());
            resource.getContents().add((Object)userManagement);
        }
        userManagement = (UserManagement)resource.getContents().get(0);
        this.addAvailablePermissions(userManagement);
        Role adminRole = this.addOrUpdateAdminRole(userManagement);
        this.addOrUpdateRegisteredRole(userManagement);
        this.addOrUpdateAnonymousRole(userManagement);
        this.addAdminUserIfMissing(adminRole, userManagement);
        transaction.commit();
    }

    private Role addOrUpdateRegisteredRole(UserManagement userManagement) {
        Role role = userManagement.findRoleByName("Registered");
        if (role == null) {
            role = UsersFactory.eINSTANCE.createRole();
            role.setName("Registered");
            this.addPermission(userManagement, role, "Workspace:view");
            this.addPermission(userManagement, role, "Project:*:view");
            this.addPermission(userManagement, role, "Project:*:suggest");
            userManagement.getRoles().add((Object)role);
        }
        return role;
    }

    private void addOrUpdateAnonymousRole(UserManagement userManagement) {
        User anonUser;
        Role role = userManagement.findRoleByName("Anonymous");
        if (role == null) {
            role = UsersFactory.eINSTANCE.createRole();
            role.setName("Anonymous");
            this.addPermission(userManagement, role, "Workspace:view");
            this.addPermission(userManagement, role, "Project:*:view");
            userManagement.getRoles().add((Object)role);
        }
        if ((anonUser = userManagement.findUserByName(role.getName())) != null && !anonUser.getRoles().contains((Object)role)) {
            anonUser.getRoles().add((Object)role);
        }
    }

    private void addPermission(UserManagement userManagement, Role role, String permissionName) {
        Permission permission = this.getPermission((EList<Permission>)userManagement.getPermissions(), permissionName);
        if (permission == null) {
            permission = UsersFactory.eINSTANCE.createPermission();
            permission.setName(permissionName);
            userManagement.getPermissions().add((Object)permission);
        }
        role.getPermissions().add((Object)permission);
    }

    private Role addOrUpdateAdminRole(UserManagement userManagement) {
        Role adminRole = userManagement.findRoleByName("Administrator");
        if (adminRole == null) {
            adminRole = this.addAdminRole(userManagement);
        }
        EList allPermissions = userManagement.getPermissions();
        Permission wildcardPermission = this.getPermission((EList<Permission>)allPermissions, "*");
        adminRole.getPermissions().add((Object)wildcardPermission);
        return adminRole;
    }

    private User getAnonymousUser() {
        User anonymous = UsersFactory.eINSTANCE.createUser();
        anonymous.setName("Anonymous");
        anonymous.setPassword("ThereIsNoPasswordForAnonymous");
        anonymous.setType("DB");
        return anonymous;
    }

    private User getAdminUser() {
        User admin = UsersFactory.eINSTANCE.createUser();
        admin.setName("Administrator");
        admin.setPassword("changeme");
        admin.setType("DB");
        return admin;
    }

    private Role addAdminRole(UserManagement userManagement) {
        Role adminRole = UsersFactory.eINSTANCE.createRole();
        adminRole.setName("Administrator");
        userManagement.getRoles().add((Object)adminRole);
        return adminRole;
    }

    private void addAdminUserIfMissing(Role adminRole, UserManagement userManagement) {
        EList users = userManagement.getUsers();
        for (User user : users) {
            for (Role role : user.getRoles()) {
                if (!role.equals(adminRole)) continue;
                return;
            }
        }
        User admin = userManagement.findUserByName("Administrator");
        admin.getRoles().add((Object)adminRole);
    }

    private void addAvailablePermissions(UserManagement userManagement) {
        IConfigurationElement[] permissions = RegistryFactory.getRegistry().getConfigurationElementsFor("org.jabylon.security.permission");
        EList dbPermissions = userManagement.getPermissions();
        for (IConfigurationElement config : permissions) {
            String permissionName = config.getAttribute("name");
            if (this.getPermission((EList<Permission>)dbPermissions, permissionName) != null) continue;
            String permissionDescription = config.getAttribute("description");
            Permission perm = UsersFactory.eINSTANCE.createPermission();
            perm.setName(permissionName);
            perm.setDescription(permissionDescription);
            dbPermissions.add((Object)perm);
        }
        if (this.getPermission((EList<Permission>)dbPermissions, "*") == null) {
            Permission perm = UsersFactory.eINSTANCE.createPermission();
            perm.setName("*");
            perm.setDescription("All Permissions");
            dbPermissions.add((Object)perm);
        }
    }

    private Permission getPermission(EList<Permission> dbPermissions, String permissionName) {
        for (Permission permission : dbPermissions) {
            if (!permission.getName().equals(permissionName)) continue;
            return permission;
        }
        return null;
    }

    private void initializeWorkspace(CDOTransaction transaction) throws CommitException {
        if (!transaction.hasResource("workspace")) {
            CDOResource resource = transaction.createResource("workspace");
            Workspace workspace = PropertiesFactory.eINSTANCE.createWorkspace();
            URI uri = URI.createFileURI((String)ServerConstants.WORKSPACE_DIR);
            File root = new File(ServerConstants.WORKSPACE_DIR);
            if (!root.exists()) {
                root.mkdirs();
            }
            workspace.setRoot(uri);
            resource.getContents().add((Object)workspace);
            transaction.commit();
        }
    }

    public CDONet4jSession createSession() {
        IPluginContainer container = IPluginContainer.INSTANCE;
        IJVMConnector connector = JVMUtil.getConnector((IManagedContainer)container, (String)"default");
        CDONet4jSessionConfiguration config = CDONet4jUtil.createNet4jSessionConfiguration();
        config.setConnector((IConnector)connector);
        config.setRepositoryName("jabylon");
        CDONet4jSession session = config.openNet4jSession();
        session.options().setCollectionLoadingPolicy(CDOUtil.createCollectionLoadingPolicy((int)-1, (int)-1));
        session.getPackageRegistry().putEPackage((EPackage)PropertiesPackage.eINSTANCE);
        session.getPackageRegistry().putEPackage((EPackage)UsersPackage.eINSTANCE);
        return session;
    }

    private void startRepository() {
        IPluginContainer container = IPluginContainer.INSTANCE;
        logger.info("Starting Repository");
        if (this.acceptor == null) {
            this.acceptor = JVMUtil.getAcceptor((IManagedContainer)container, (String)"default");
        }
        if (this.repository == null) {
            this.repository = this.createRepository();
            CDOServerUtil.addRepository((IManagedContainer)container, (IRepository)this.repository);
            logger.info("Repository Started");
        }
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        if (this.acceptor != null) {
            LifecycleUtil.deactivate((Object)this.acceptor);
        }
        if (this.repository != null) {
            LifecycleUtil.deactivate((Object)this.repository);
        }
    }

    private IRepository createRepository() {
        logger.info("Creating Repository in {}", (Object)ServerConstants.WORKING_DIR);
        HashMap props = new HashMap();
        return CDOServerUtil.createRepository((String)"jabylon", (IStore)this.createStore(), props);
    }

    private IStore createStore() {
        String DATABASE_NAME = ServerConstants.WORKING_DIR + "/cdo/embedded/h2;DB_CLOSE_ON_EXIT=FALSE";
        JdbcDataSource dataSource = new JdbcDataSource();
        dataSource.setURL("jdbc:h2:" + DATABASE_NAME + ";DB_CLOSE_DELAY=-1");
        IMappingStrategy mappingStrategy = CDODBUtil.createHorizontalMappingStrategy((boolean)false);
        H2Adapter adapter = new H2Adapter();
        new DBMigrator().migrate((DataSource)dataSource);
        IDBStore store = CDODBUtil.createStore((IMappingStrategy)mappingStrategy, (IDBAdapter)adapter, (IDBConnectionProvider)DBUtil.createConnectionProvider((DataSource)dataSource));
        mappingStrategy.setStore(store);
        return store;
    }

    static {
        logger = LoggerFactory.getLogger(Activator.class);
    }
}

