/*
 * Decompiled with CFR 0.152.
 */
package org.jabylon.cdo.server.logging;

import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.osgi.service.log.LogEntry;
import org.osgi.service.log.LogListener;
import org.osgi.service.log.LogReaderService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.helpers.BasicMarkerFactory;

@Component
public class OSGiLogger
implements LogListener {
    @Reference
    private LogReaderService logReader;
    private Logger logger = LoggerFactory.getLogger(OSGiLogger.class);
    private BasicMarkerFactory factory = new BasicMarkerFactory();

    public void bindLogReader(LogReaderService service) {
        this.logReader = service;
        this.logReader.addLogListener((LogListener)this);
    }

    public void unbindLogReader(LogReaderService service) {
        service.removeLogListener((LogListener)this);
        this.logReader = null;
    }

    public void logged(LogEntry entry) {
        Marker marker = null;
        if (entry.getBundle() != null) {
            marker = this.factory.getMarker(entry.getBundle().getSymbolicName());
        }
        switch (entry.getLevel()) {
            case 4: {
                this.logger.debug(marker, entry.getMessage(), entry.getException());
                break;
            }
            case 1: {
                this.logger.error(marker, entry.getMessage(), entry.getException());
                break;
            }
            case 3: {
                this.logger.info(marker, entry.getMessage(), entry.getException());
                break;
            }
            case 2: {
                this.logger.warn(marker, entry.getMessage(), entry.getException());
            }
        }
    }
}

