/*
 * Decompiled with CFR 0.152.
 */
package org.jabylon.db.migration;

import com.googlecode.flyway.core.Flyway;
import com.googlecode.flyway.core.api.MigrationInfo;
import com.googlecode.flyway.core.api.MigrationVersion;
import com.googlecode.flyway.core.util.logging.LogCreator;
import com.googlecode.flyway.core.util.logging.LogFactory;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import org.jabylon.db.migration.SLF4JLogCreator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBMigrator {
    private static final Logger logger = LoggerFactory.getLogger(DBMigrator.class);

    public void migrate(DataSource dataSource) {
        this.initializeLogging();
        this.migrateDB(dataSource);
    }

    private void migrateDB(DataSource dataSource) {
        MigrationInfo current;
        MigrationVersion migrationVersion;
        boolean dbExists = this.dbExists(dataSource);
        Flyway flyway = new Flyway();
        flyway.setDataSource(dataSource);
        flyway.setTable("SCHEMA_VERSION");
        if (!dbExists && (migrationVersion = this.getLatestVersion(flyway)) != null) {
            flyway.setInitVersion(migrationVersion);
        }
        if ((current = flyway.info().current()) == null) {
            flyway.init();
        }
        flyway.migrate();
    }

    private MigrationVersion getLatestVersion(Flyway flyway) {
        MigrationInfo[] pending = flyway.info().pending();
        if (pending == null || pending.length == 0) {
            return null;
        }
        return pending[pending.length - 1].getVersion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean dbExists(DataSource dataSource) {
        Connection connection = null;
        Statement statement = null;
        try {
            connection = dataSource.getConnection();
            statement = connection.createStatement();
            ResultSet result = statement.executeQuery("SELECT TABLE_SCHEMA FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_NAME = 'WORKSPACE'");
            boolean hasResult = result.next();
            result.close();
            statement.close();
            connection.close();
            boolean bl = hasResult;
            return bl;
        }
        catch (SQLException e) {
            logger.error("Failed to determine if the DB already exists", (Throwable)e);
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (SQLException e) {
                    logger.warn("Failed to close connection", (Throwable)e);
                }
            }
        }
        return false;
    }

    private void initializeLogging() {
        LogFactory.setLogCreator((LogCreator)new SLF4JLogCreator());
    }
}

