/*
 * Decompiled with CFR 0.152.
 */
package org.jabylon.rest.ui;

import org.jabylon.cdo.connector.RepositoryConnector;
import org.jabylon.common.progress.ProgressService;
import org.jabylon.common.resolver.URIResolver;
import org.jabylon.resources.persistence.PropertyPersistenceService;
import org.jabylon.security.auth.AuthenticationService;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;

public class Activator
implements BundleActivator {
    public static final String BUNDLE_ID = "org.jabylon.rest.ui";
    private static Activator INSTANCE;
    private BundleContext context;
    private ServiceTracker<RepositoryConnector, RepositoryConnector> repositoryConnectorTracker;
    private ServiceTracker<URIResolver, URIResolver> lookupTracker;
    private ServiceTracker<ProgressService, ProgressService> progressServiceTracker;
    private ServiceTracker<AuthenticationService, AuthenticationService> authenticationServiceTracker;
    private ServiceTracker<PropertyPersistenceService, PropertyPersistenceService> persistenceService;

    public void start(BundleContext context) throws Exception {
        INSTANCE = this;
        this.context = context;
        new Thread(new Runnable(){

            @Override
            public void run() {
                Activator.this.startTrackers();
            }
        }, "UI Service Tracker").start();
    }

    private void startTrackers() {
        this.repositoryConnectorTracker = new ServiceTracker(this.context, RepositoryConnector.class, null);
        this.repositoryConnectorTracker.open();
        this.lookupTracker = new ServiceTracker(this.context, URIResolver.class, null);
        this.lookupTracker.open();
        this.progressServiceTracker = new ServiceTracker(this.context, ProgressService.class, null);
        this.progressServiceTracker.open();
        this.authenticationServiceTracker = new ServiceTracker(this.context, AuthenticationService.class, null);
        this.authenticationServiceTracker.open();
        this.persistenceService = new ServiceTracker(this.context, PropertyPersistenceService.class, null);
        this.persistenceService.open();
    }

    public void stop(BundleContext context) throws Exception {
        this.lookupTracker.close();
        this.progressServiceTracker.close();
        this.repositoryConnectorTracker.close();
        this.authenticationServiceTracker.close();
        INSTANCE = null;
        this.context = null;
    }

    public static Activator getDefault() {
        return INSTANCE;
    }

    public RepositoryConnector getRepositoryConnector() {
        return (RepositoryConnector)this.repositoryConnectorTracker.getService();
    }

    public ProgressService getProgressService() {
        return (ProgressService)this.progressServiceTracker.getService();
    }

    public AuthenticationService getAuthenticationService() {
        return (AuthenticationService)this.authenticationServiceTracker.getService();
    }

    public PropertyPersistenceService getPersistenceService() {
        return (PropertyPersistenceService)this.persistenceService.getService();
    }

    public URIResolver getRepositoryLookup() {
        return (URIResolver)this.lookupTracker.getService();
    }

    public BundleContext getContext() {
        return this.context;
    }
}

