/*
 * Decompiled with CFR 0.152.
 */
package org.jabylon.rest.ui.model;

import java.util.Collection;
import org.apache.wicket.model.IModel;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.jabylon.rest.ui.model.AttachableModel;
import org.jabylon.rest.ui.model.EObjectPropertyModel;
import org.jabylon.rest.ui.model.IEObjectModel;

public class AttachableWritableModel<T extends CDOObject>
implements IEObjectModel<T>,
AttachableModel<T> {
    private static final long serialVersionUID = 1L;
    private String eClass;
    private String namespace;
    private String containmentFeature;
    private IModel<? extends CDOObject> parent;
    private transient T model;

    public AttachableWritableModel(EClass eClass, IModel<? extends CDOObject> parent, EStructuralFeature containmentFeature) {
        this.eClass = eClass.getName();
        this.namespace = eClass.getEPackage().getNsURI();
        this.parent = parent;
        this.containmentFeature = containmentFeature.getName();
    }

    public AttachableWritableModel(EClass eClass, IModel<? extends CDOObject> parent) {
        this(eClass, parent, AttachableWritableModel.computeContainmentFeature(eClass, parent));
    }

    private static EStructuralFeature computeContainmentFeature(EClass eClass, IModel<? extends CDOObject> parent) {
        EList containments = ((CDOObject)parent.getObject()).eClass().getEAllContainments();
        for (EReference eReference : containments) {
            if (!eReference.getEType().getInstanceClass().isAssignableFrom(eClass.getInstanceClass())) continue;
            return eReference;
        }
        throw new IllegalArgumentException("Could not compute the correct containment feature for the given eclass");
    }

    public void detach() {
        this.parent.detach();
    }

    public T getObject() {
        if (this.model == null) {
            this.model = this.createModel();
        }
        return this.model;
    }

    private T createModel() {
        EClassifier classifier = EPackage.Registry.INSTANCE.getEPackage(this.namespace).getEClassifier(this.eClass);
        CDOObject object = (CDOObject)EcoreUtil.create((EClass)((EClass)classifier));
        return (T)object;
    }

    public void setObject(T object) {
        this.model = object;
    }

    @Override
    public <X> IModel<X> forProperty(EStructuralFeature feature) {
        return new EObjectPropertyModel(this, feature);
    }

    @Override
    public void attach() {
        CDOObject container = (CDOObject)this.parent.getObject();
        EStructuralFeature feature = container.eClass().getEStructuralFeature(this.containmentFeature);
        if (feature.isMany()) {
            Collection c = (Collection)container.eGet(feature);
            c.add(this.getObject());
        } else {
            container.eSet(feature, this.getObject());
        }
    }

    @Override
    public IModel<?> getParent() {
        return this.parent;
    }
}

