/*
 * Decompiled with CFR 0.152.
 */
package org.jabylon.rest.ui.model;

import java.io.Serializable;
import java.util.Locale;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.jabylon.properties.PropertiesFactory;
import org.jabylon.properties.Property;

public class PropertyPair
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Property template;
    private Property translation;
    private Locale language;
    private CDOID descriptorID;

    public PropertyPair(Property template, Property translation, Locale language, CDOID descriptorID) {
        this.template = template;
        this.translation = translation;
        this.language = language;
        this.descriptorID = descriptorID;
    }

    public Property getTemplate() {
        return this.template;
    }

    public Property getTranslation() {
        return this.translation;
    }

    public String getOriginal() {
        if (this.getTemplate() == null) {
            return "";
        }
        return this.getTemplate().getValue();
    }

    public String getTranslated() {
        if (this.getTranslation() == null) {
            return "";
        }
        return this.getTranslation().getValue();
    }

    public void setTranslated(String translated) {
        this.getOrCreateTranslation().setValue(translated);
    }

    public String getOriginalComment() {
        if (this.getTemplate() == null) {
            return "";
        }
        return this.getTemplate().getComment();
    }

    public void setOriginalComment(String comment) {
    }

    public void setOriginal(String comment) {
    }

    public String getTranslatedComment() {
        if (this.getTranslation() == null) {
            return "";
        }
        return this.getTranslation().getComment();
    }

    public void setTranslatedComment(String comment) {
        this.getOrCreateTranslation().setComment(comment);
    }

    public CDOID getDescriptorID() {
        return this.descriptorID;
    }

    public Property getOrCreateTranslation() {
        Property property = this.getTranslation();
        if (property == null) {
            property = PropertiesFactory.eINSTANCE.createProperty();
            property.setKey(this.getTemplate().getKey());
            this.translation = property;
        }
        return property;
    }

    public String getKey() {
        if (this.template != null) {
            return this.template.getKey();
        }
        if (this.translation != null) {
            return this.translation.getKey();
        }
        return null;
    }

    public Locale getLanguage() {
        return this.language;
    }
}

