/*
 * Decompiled with CFR 0.152.
 */
package org.jabylon.rest.ui.navbar;

import java.io.Serializable;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.form.StatelessForm;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.StringResourceModel;
import org.apache.wicket.request.Url;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.eclipse.emf.common.util.URI;
import org.jabylon.properties.Resolvable;
import org.jabylon.rest.ui.wicket.BasicPanel;
import org.jabylon.rest.ui.wicket.PanelFactory;
import org.jabylon.rest.ui.wicket.pages.SearchPage;

public class SearchPanel<T>
extends BasicPanel<T> {
    private static final long serialVersionUID = 1L;

    public SearchPanel(String id, IModel<T> object, PageParameters parameters) {
        super(id, object, parameters);
        this.add(new Component[]{new SearchForm("form")});
        this.setVersioned(false);
    }

    public class SearchForm
    extends StatelessForm<Void> {
        private static final long serialVersionUID = 1L;
        private String searchString;

        public SearchForm(String id) {
            super(id);
            TextField field = new TextField("searchfield", (IModel)new PropertyModel((Object)this, "searchString"));
            StringResourceModel placeholder = this.getPlaceholder(SearchPanel.this.getModel());
            field.add(new Behavior[]{new AttributeModifier("placeholder", (IModel)placeholder)});
            this.add(new Component[]{field});
        }

        public void onSubmit() {
            Url url = this.getRequest().getUrl();
            URI uri = URI.createURI((String)url.getPath(), (boolean)false);
            PageParameters params = new PageParameters();
            params.add("t", (Object)this.getSearchString());
            String scope = SearchPanel.this.getPageParameters().get("s").toString(uri.toString());
            params.add("s", (Object)scope);
            this.setResponsePage(SearchPage.class, params);
        }

        public String getSearchString() {
            return this.searchString;
        }

        public void setSearchString(String searchString) {
            this.searchString = searchString;
        }

        private StringResourceModel getPlaceholder(IModel<T> model) {
            Resolvable r;
            StringResourceModel plainModel = new StringResourceModel("SearchPanel.search.placeholder", (Component)SearchPanel.this, null, new Object[0]);
            if (model == null) {
                return plainModel;
            }
            Object object = model.getObject();
            if (object instanceof Resolvable && (r = (Resolvable)object).getName() != null && !r.getName().isEmpty()) {
                return new StringResourceModel("SearchPanel.scoped.search.placeholder", (Component)SearchPanel.this, null, "", new Object[]{r.getName()});
            }
            return plainModel;
        }
    }

    public static class SearchPanelFactory
    implements PanelFactory<Object>,
    Serializable {
        private static final long serialVersionUID = 1L;

        @Override
        public Panel createPanel(PageParameters params, IModel<Object> input, String id) {
            return new SearchPanel<Object>(id, input, params);
        }
    }
}

