/*
 * Decompiled with CFR 0.152.
 */
package org.jabylon.rest.ui.security;

import java.util.ArrayList;
import org.apache.wicket.authroles.authentication.AuthenticatedWebSession;
import org.apache.wicket.authroles.authorization.strategies.role.Roles;
import org.apache.wicket.model.IModel;
import org.apache.wicket.request.Request;
import org.eclipse.emf.common.util.EList;
import org.jabylon.rest.ui.Activator;
import org.jabylon.rest.ui.model.EObjectModel;
import org.jabylon.security.auth.AuthenticationService;
import org.jabylon.users.Permission;
import org.jabylon.users.Role;
import org.jabylon.users.User;
import org.jabylon.users.UserManagement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CDOAuthenticatedSession
extends AuthenticatedWebSession {
    private static final long serialVersionUID = 1L;
    private IModel<User> user;
    private IModel<User> anonymousUser;
    private IModel<UserManagement> userManagementModel;
    private static final Logger logger = LoggerFactory.getLogger(CDOAuthenticatedSession.class);

    public CDOAuthenticatedSession(Request request) {
        super(request);
    }

    public void detach() {
        super.detach();
        if (this.user != null) {
            this.user.detach();
        }
        if (this.anonymousUser != null) {
            this.anonymousUser.detach();
        }
        if (this.userManagementModel != null) {
            this.userManagementModel.detach();
        }
    }

    public boolean hasPermission(String permission) {
        User user = this.getUser();
        if (user == null) {
            user = this.getAnonymousUser();
        }
        if (user != null) {
            return user.hasPermission(permission);
        }
        return false;
    }

    private UserManagement getUserManagement() {
        if (this.userManagementModel == null) {
            Object resolved = Activator.getDefault().getRepositoryLookup().resolve("security");
            if (resolved instanceof UserManagement) {
                UserManagement managment = (UserManagement)resolved;
                this.userManagementModel = new EObjectModel<UserManagement>(managment);
                return managment;
            }
            logger.error("Failed to obtain UserManagement");
            return null;
        }
        return (UserManagement)this.userManagementModel.getObject();
    }

    public boolean authenticate(String username, String password) {
        AuthenticationService service = Activator.getDefault().getAuthenticationService();
        User user = service.authenticateUser(username, password);
        if (user == null) {
            return false;
        }
        this.user = new EObjectModel<User>(user);
        return true;
    }

    public Roles getRoles() {
        if (this.isSignedIn()) {
            EList permissions = ((User)this.user.getObject()).getAllPermissions();
            return this.createRoles((EList<Permission>)permissions);
        }
        return this.getAnonymousRoles();
    }

    private Roles createRoles(EList<Permission> permissions) {
        ArrayList<String> roleNames = new ArrayList<String>(permissions.size());
        for (Permission permission : permissions) {
            roleNames.add(permission.getName());
        }
        return new Roles(roleNames.toArray(new String[permissions.size()]));
    }

    private Roles getAnonymousRoles() {
        logger.info("Computing Anonymous Roles");
        Role role = this.getUserManagement().findRoleByName("Anonymous");
        Roles roles = this.createRoles((EList<Permission>)role.getAllPermissions());
        return roles;
    }

    public User getUser() {
        if (this.user == null) {
            return null;
        }
        return (User)this.user.getObject();
    }

    public User getAnonymousUser() {
        if (this.anonymousUser == null) {
            if (this.getUserManagement() == null) {
                return null;
            }
            User anonymous = Activator.getDefault().getAuthenticationService().getAnonymousUser();
            if (anonymous != null) {
                this.anonymousUser = new EObjectModel<User>(anonymous);
            } else {
                return null;
            }
        }
        return (User)this.anonymousUser.getObject();
    }
}

