/*
 * Decompiled with CFR 0.152.
 */
package org.jabylon.rest.ui.tools;

import java.io.IOException;
import java.io.Serializable;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import javax.inject.Inject;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.image.Image;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.GenericPanel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.common.util.URI;
import org.jabylon.common.resolver.URIResolver;
import org.jabylon.index.properties.QueryService;
import org.jabylon.index.properties.SearchResult;
import org.jabylon.properties.PropertiesFactory;
import org.jabylon.properties.PropertiesPackage;
import org.jabylon.properties.PropertyFileDescriptor;
import org.jabylon.rest.ui.model.PropertyPair;
import org.jabylon.rest.ui.util.WicketUtil;
import org.jabylon.rest.ui.wicket.pages.ResourcePage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OtherTranslationsToolPanel
extends GenericPanel<PropertyPair> {
    private static final long serialVersionUID = 1L;
    private static Logger logger = LoggerFactory.getLogger(OtherTranslationsToolPanel.class);
    @Inject
    private QueryService queryService;
    @Inject
    private URIResolver resolver;

    public OtherTranslationsToolPanel(String id, IModel<PropertyPair> model) {
        super(id, model);
    }

    protected void onBeforeRender() {
        List<MatchResult> result = this.doSearch((IModel<PropertyPair>)this.getModel());
        ListView<MatchResult> list = new ListView<MatchResult>("children", result){
            private static final long serialVersionUID = 1L;

            protected void populateItem(ListItem<MatchResult> item) {
                MatchResult match = (MatchResult)item.getModelObject();
                item.add(new Component[]{new Label("locale", match.getLocale().getDisplayName(this.getLocale()))});
                item.add(new Component[]{new Label("translation", match.getValue())});
                PageParameters params = new PageParameters();
                URI uri = URI.createURI((String)match.getUri());
                for (int i = 0; i < uri.segmentCount(); ++i) {
                    params.set(i, (Object)uri.segment(i));
                }
                params.add("key", (Object)((PropertyPair)OtherTranslationsToolPanel.this.getModel().getObject()).getKey());
                item.add(new Component[]{new BookmarkablePageLink("link", ResourcePage.class, params)});
                Image image = new Image("flag", WicketUtil.getIconForLocale(match.getLocale()));
                item.add(new Component[]{image});
            }
        };
        this.addOrReplace(new Component[]{list});
        super.onBeforeRender();
    }

    protected List<MatchResult> doSearch(IModel<PropertyPair> model) {
        ScoreDoc[] doc;
        long time = System.currentTimeMillis();
        PropertyPair pair = (PropertyPair)model.getObject();
        if (pair == null || pair.getOriginal() == null) {
            return Collections.emptyList();
        }
        CDOID descriptorID = ((PropertyPair)model.getObject()).getDescriptorID();
        PropertyFileDescriptor descriptor = (PropertyFileDescriptor)this.resolver.resolve(descriptorID);
        if (descriptor.getMaster() == null) {
            return Collections.emptyList();
        }
        BooleanQuery query = new BooleanQuery();
        query.add((Query)new TermQuery(new Term("templatePath", descriptor.getMaster().getLocation().toString())), BooleanClause.Occur.MUST);
        query.add((Query)new TermQuery(new Term("key", pair.getKey())), BooleanClause.Occur.MUST);
        query.add((Query)new TermQuery(new Term("locale", "master")), BooleanClause.Occur.MUST_NOT);
        query.add((Query)new TermQuery(new Term("locale", descriptor.getProjectLocale().getLocale().toString())), BooleanClause.Occur.MUST_NOT);
        SearchResult result = this.queryService.search((Query)query, 50);
        if (result == null) {
            return Collections.emptyList();
        }
        ArrayList<MatchResult> resultSet = new ArrayList<MatchResult>();
        TopDocs topDocs = result.getTopDocs();
        for (ScoreDoc scoreDoc : doc = topDocs.scoreDocs) {
            try {
                Document document = result.getSearcher().doc(scoreDoc.doc);
                PropertyFileDescriptor foundDescriptor = this.queryService.getDescriptor(document);
                if (foundDescriptor == null) continue;
                String uri = foundDescriptor.toURI().toString();
                Locale locale = (Locale)PropertiesFactory.eINSTANCE.createFromString(PropertiesPackage.Literals.LOCALE, document.get("locale"));
                MatchResult match = new MatchResult(document.get("value"), locale, uri);
                resultSet.add(match);
            }
            catch (CorruptIndexException e) {
                logger.error("Failed to find other translations", (Throwable)e);
            }
            catch (IOException e) {
                logger.error("Failed to find other translations", (Throwable)e);
            }
        }
        logger.debug("Finding other translations took {} ms", (Object)(System.currentTimeMillis() - time));
        Collections.sort(resultSet, new MatchResultComparator(this.getLocale()));
        return resultSet;
    }

    private static class MatchResultComparator
    implements Comparator<MatchResult> {
        private Collator collator;
        private Locale locale;

        public MatchResultComparator(Locale locale) {
            this.collator = Collator.getInstance(locale);
            this.locale = locale;
        }

        @Override
        public int compare(MatchResult o1, MatchResult o2) {
            return this.collator.compare(o1.getLocale().getDisplayLanguage(this.locale), o2.getLocale().getDisplayLanguage(this.locale));
        }
    }

    public static class MatchResult
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String uri;
        private Locale locale;
        private String value;

        public MatchResult(String value, Locale locale, String uri) {
            this.value = value;
            this.locale = locale;
            this.uri = uri;
        }

        public Locale getLocale() {
            return this.locale;
        }

        public String getUri() {
            return this.uri;
        }

        public String getValue() {
            return this.value;
        }
    }
}

