/*
 * Decompiled with CFR 0.152.
 */
package org.jabylon.rest.ui.tools;

import java.io.Serializable;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.inject.Inject;
import org.apache.wicket.Component;
import org.apache.wicket.Session;
import org.apache.wicket.behavior.AttributeAppender;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.OnDomReadyHeaderItem;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.StatelessLink;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.util.CommitException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.jabylon.cdo.connector.Modification;
import org.jabylon.cdo.connector.TransactionUtil;
import org.jabylon.common.resolver.URIResolver;
import org.jabylon.properties.Comment;
import org.jabylon.properties.Project;
import org.jabylon.properties.ProjectVersion;
import org.jabylon.properties.PropertyFileDescriptor;
import org.jabylon.properties.Review;
import org.jabylon.properties.ReviewState;
import org.jabylon.properties.Severity;
import org.jabylon.rest.ui.model.EObjectModel;
import org.jabylon.rest.ui.model.PropertyPair;
import org.jabylon.rest.ui.security.CDOAuthenticatedSession;
import org.jabylon.rest.ui.wicket.BasicPanel;
import org.jabylon.security.CommonPermissions;
import org.jabylon.users.User;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReviewToolPanel
extends BasicPanel<PropertyPair> {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(ReviewToolPanel.class);
    private static final String JS = "$(\"#review-tool-table i.icon-share\").click(function () { var translation = $(this).prev(\"span\");var widget = $(\"#translation\");if(widget.attr(\"readonly\")!=='readonly') {widget.val(translation.text());markDirty();};});";
    @Inject
    private URIResolver resolver;

    public ReviewToolPanel(String id, IModel<PropertyPair> model) {
        super(id, model);
    }

    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        response.render((HeaderItem)OnDomReadyHeaderItem.forScript((CharSequence)JS));
    }

    @Override
    protected void onBeforeRenderPanel() {
        super.onBeforeRenderPanel();
        this.setOutputMarkupId(true);
        PropertyFileDescriptor descriptor = this.getDescriptor((IModel<PropertyPair>)this.getModel());
        List<IModel<Review>> matchingReviews = this.computeMatchingReviews(descriptor);
        final boolean hasEditPermission = this.hasEditPermission(descriptor);
        WebMarkupContainer container = new WebMarkupContainer("container");
        container.setOutputMarkupId(true);
        ListView<IModel<Review>> view = new ListView<IModel<Review>>("reviews", matchingReviews){
            private static final long serialVersionUID = 1L;

            protected void populateItem(ListItem<IModel<Review>> item) {
                Review review = (Review)((IModel)item.getModelObject()).getObject();
                Label label = new Label("status", review.getReviewType());
                label.add(new Behavior[]{new AttributeAppender("class", (Serializable)((Object)ReviewToolPanel.this.getLabelClass(review)))});
                item.add(new Component[]{label});
                item.add(new Component[]{new Label("message", review.getMessage())});
                WebMarkupContainer copy = new WebMarkupContainer("copy");
                copy.setVisibilityAllowed(hasEditPermission && "Suggestion".equals(review.getReviewType()));
                item.add(new Component[]{copy});
                if ("Suggestion".equals(review.getReviewType())) {
                    String comment = "";
                    if (!review.getComments().isEmpty()) {
                        comment = ": " + ((Comment)review.getComments().get(0)).getMessage();
                    }
                    item.add(new Component[]{new Label("notes", (IModel)ReviewToolPanel.this.nls("user.review.notes", new Object[]{review.getUser(), comment}))});
                } else {
                    item.add(new Component[]{new Label("notes", "")});
                }
                EObjectModel<Review> reviewModel = new EObjectModel<Review>(review);
                RejectLink rejectButton = new RejectLink("reject", reviewModel, ReviewToolPanel.this.getPageParameters());
                DateFormat formatter = SimpleDateFormat.getDateTimeInstance(3, 3, this.getSession().getLocale());
                item.add(new Component[]{rejectButton});
                String created = review.getCreated() > 0L ? formatter.format(new Date(review.getCreated())) : "";
                item.add(new Component[]{new Label("created", created)});
                rejectButton.setVisibilityAllowed(hasEditPermission);
            }
        };
        container.add(new Component[]{view});
        this.addOrReplace(new Component[]{container});
    }

    protected boolean hasEditPermission(PropertyFileDescriptor descriptor) {
        CDOAuthenticatedSession authSession;
        User user;
        Session session = this.getSession();
        if (session instanceof CDOAuthenticatedSession && (user = (authSession = (CDOAuthenticatedSession)session).getUser()) != null) {
            Project project = (Project)((ProjectVersion)descriptor.getProjectLocale().getParent()).getParent();
            String permission = CommonPermissions.constructPermissionName((String)"Project", (String)project.getName(), (String)"edit");
            return user.hasPermission(permission);
        }
        return false;
    }

    private List<IModel<Review>> computeMatchingReviews(PropertyFileDescriptor descriptor) {
        ArrayList<IModel<Review>> matchingReviews = new ArrayList<IModel<Review>>();
        if (descriptor != null) {
            EList reviews = descriptor.getReviews();
            for (Review review : reviews) {
                if ((!review.getKey().equals(((PropertyPair)this.getModel().getObject()).getKey()) || review.getState() != ReviewState.OPEN) && review.getState() != ReviewState.REOPENED) continue;
                matchingReviews.add(new EObjectModel<Review>(review));
            }
        }
        return matchingReviews;
    }

    protected String getLabelClass(Review review) {
        Severity severity = review.getSeverity();
        switch (severity) {
            case ERROR: {
                return " label-important";
            }
            case INFO: {
                return " label-info";
            }
            case WARNING: {
                return " label-warning";
            }
        }
        return "";
    }

    private PropertyFileDescriptor getDescriptor(IModel<PropertyPair> pair) {
        CDOID descriptorID;
        CDOObject object;
        if (this.getModel().getObject() != null && (object = this.resolver.resolve(descriptorID = ((PropertyPair)this.getModel().getObject()).getDescriptorID())) instanceof PropertyFileDescriptor) {
            PropertyFileDescriptor descriptor = (PropertyFileDescriptor)object;
            return descriptor;
        }
        return null;
    }

    private static class RejectLink
    extends StatelessLink<Review> {
        private static final long serialVersionUID = 1L;
        private IModel<Review> model;
        private PageParameters returnAddress;

        public RejectLink(String id, IModel<Review> model, PageParameters returnAddress) {
            super(id);
            this.model = model;
            this.returnAddress = returnAddress;
        }

        public void onClick() {
            Review theReview = (Review)this.model.getObject();
            try {
                TransactionUtil.commit((EObject)theReview, (Modification)new Modification<Review, Review>(){

                    public Review apply(Review object) {
                        object.setState(ReviewState.INVALID);
                        return object;
                    }
                });
                this.setResponsePage(this.getPage().getPageClass(), this.returnAddress);
            }
            catch (CommitException e) {
                LOG.error("Failed to commit updated review state", (Throwable)e);
            }
        }
    }
}

