/*
 * Decompiled with CFR 0.152.
 */
package org.jabylon.rest.ui.tools;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.TreeSet;
import javax.inject.Inject;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.FuzzyLikeThisQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.util.Version;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.AttributeAppender;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.OnDomReadyHeaderItem;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.GenericPanel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.common.util.URI;
import org.jabylon.index.properties.QueryService;
import org.jabylon.index.properties.SearchResult;
import org.jabylon.properties.Project;
import org.jabylon.properties.ProjectVersion;
import org.jabylon.properties.PropertiesFactory;
import org.jabylon.properties.Property;
import org.jabylon.properties.PropertyFileDescriptor;
import org.jabylon.rest.ui.Activator;
import org.jabylon.rest.ui.model.PropertyPair;
import org.jabylon.rest.ui.wicket.pages.ResourcePage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimilarStringsToolPanel
extends GenericPanel<PropertyPair> {
    private static final long serialVersionUID = 1L;
    private static Logger logger = LoggerFactory.getLogger(SimilarStringsToolPanel.class);
    @Inject
    private QueryService queryService;
    private static final String JS = "$(\"#similarity-table i.icon-share\").click(function () { var translation = $(this).prev(\"span\");var widget = $(\"#translation\");if(widget.attr(\"readonly\")!=='readonly') {widget.val(translation.text());markDirty()};});";

    public SimilarStringsToolPanel(String id, IModel<PropertyPair> model) {
        super(id, model);
    }

    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        response.render((HeaderItem)OnDomReadyHeaderItem.forScript((CharSequence)JS));
    }

    protected void onBeforeRender() {
        List<Similarity> result = this.doSearch((IModel<PropertyPair>)this.getModel());
        ListView<Similarity> list = new ListView<Similarity>("children", result){
            private static final long serialVersionUID = 1L;

            protected void populateItem(ListItem<Similarity> item) {
                Similarity similarity = (Similarity)item.getModelObject();
                Label kind = new Label("kind", "");
                kind.setVisible(similarity.isSameProject());
                item.add(new Component[]{kind});
                item.add(new Component[]{new Label("template", similarity.getOriginal())});
                item.add(new Component[]{new Label("translation", similarity.getTranslation())});
                item.add(new Behavior[]{new AttributeAppender("title", (Serializable)((Object)similarity.getFullPath()))});
                PageParameters params = new PageParameters();
                URI uri = URI.createURI((String)similarity.getUri());
                for (int i = 0; i < uri.segmentCount(); ++i) {
                    params.set(i, (Object)uri.segment(i));
                }
                params.add("key", (Object)similarity.getKey());
                item.add(new Component[]{new BookmarkablePageLink("link", ResourcePage.class, params)});
                WebMarkupContainer progress = new WebMarkupContainer("similarity");
                item.add(new Component[]{progress});
                progress.add(new Behavior[]{new AttributeModifier("style", (Serializable)((Object)("width: " + similarity.getSimilarity() + "%")))});
            }
        };
        this.addOrReplace(new Component[]{list});
        super.onBeforeRender();
    }

    protected List<Similarity> doSearch(IModel<PropertyPair> model) {
        long time = System.currentTimeMillis();
        PropertyPair pair = (PropertyPair)model.getObject();
        if (pair == null || pair.getOriginal() == null) {
            return Collections.emptyList();
        }
        Project project = this.getProject(pair);
        FuzzyLikeThisQuery query = new FuzzyLikeThisQuery(10, (Analyzer)new StandardAnalyzer(Version.LUCENE_35));
        query.addTerms(pair.getOriginal(), "value", 0.6f, 3);
        query.addTerms("master", "locale", 0.99f, 3);
        SearchResult result = this.queryService.search((Query)query, 10);
        if (result == null) {
            return Collections.emptyList();
        }
        TreeSet<Similarity> resultList = new TreeSet<Similarity>();
        TopDocs topDocs = result.getTopDocs();
        ScoreDoc[] doc = topDocs.scoreDocs;
        int hitNumber = 0;
        for (ScoreDoc scoreDoc : doc) {
            if ((double)scoreDoc.score < 0.2) continue;
            try {
                Document document = result.getSearcher().doc(scoreDoc.doc);
                Similarity similarity = this.createSimilarity(document, pair.getLanguage(), (int)(scoreDoc.score * 100.0f), hitNumber++, project);
                if (similarity == null) continue;
                resultList.add(similarity);
            }
            catch (CorruptIndexException e) {
                logger.error("Failed to find similar strings", (Throwable)e);
            }
            catch (IOException e) {
                logger.error("Failed to find similar strings", (Throwable)e);
            }
        }
        try {
            result.getSearcher().close();
            logger.debug("Computing Similarities took {} ms", (Object)(System.currentTimeMillis() - time));
        }
        catch (IOException e) {
            logger.error("Failed to close searcher", (Throwable)e);
        }
        return new ArrayList<Similarity>(resultList);
    }

    private Project getProject(PropertyPair pair) {
        try {
            CDOObject object = Activator.getDefault().getRepositoryLookup().resolve(pair.getDescriptorID());
            if (object instanceof PropertyFileDescriptor) {
                PropertyFileDescriptor descriptor = (PropertyFileDescriptor)object;
                return (Project)((ProjectVersion)descriptor.getProjectLocale().getParent()).getParent();
            }
        }
        catch (Exception e) {
            logger.error("Failed to lookup project for " + pair);
        }
        return null;
    }

    private Similarity createSimilarity(Document masterDoc, Locale language, int score, int hitNumber, Project originalProject) throws CorruptIndexException, IOException {
        PropertyFileDescriptor descriptor = this.queryService.getDescriptor(masterDoc);
        if (descriptor == null) {
            return null;
        }
        String key = masterDoc.get("key");
        BooleanQuery query = new BooleanQuery();
        query.add((Query)new TermQuery(new Term("templatePath", descriptor.getLocation().toString())), BooleanClause.Occur.MUST);
        query.add((Query)new TermQuery(new Term("locale", language.toString())), BooleanClause.Occur.MUST);
        query.add((Query)new TermQuery(new Term("key", key)), BooleanClause.Occur.MUST);
        SearchResult searchResult = this.queryService.search((Query)query, 1);
        TopDocs topDocs = searchResult.getTopDocs();
        if (topDocs.totalHits == 0) {
            return null;
        }
        Document translationDoc = searchResult.getSearcher().doc(searchResult.getTopDocs().scoreDocs[0].doc);
        Property property = PropertiesFactory.eINSTANCE.createProperty();
        property.setKey(key);
        property.setValue(translationDoc.get("value"));
        property.setComment(translationDoc.get("comment"));
        PropertyFileDescriptor slave = this.queryService.getDescriptor(translationDoc);
        if (slave == null) {
            return null;
        }
        PropertyPair pair = (PropertyPair)this.getModelObject();
        if (pair.getKey().equals(key) && slave.cdoID().equals(pair.getDescriptorID())) {
            return null;
        }
        URI originalProjectPath = originalProject.fullPath();
        String resultPath = masterDoc.get("path");
        boolean isSameProject = resultPath.startsWith(originalProjectPath.path() + "/");
        Similarity similarity = new Similarity(masterDoc.get("value"), translationDoc.get("value"), score, masterDoc.get("path"), slave.toURI().toString(), key, hitNumber, isSameProject);
        return similarity;
    }

    public static class Similarity
    implements Serializable,
    Comparable<Similarity> {
        private static final long serialVersionUID = 1L;
        private String original;
        private String translation;
        private int similarity;
        private String fullPath;
        private String uri;
        private String key;
        private int orderNumber;
        private boolean sameProject;

        public Similarity(String original, String translation, int similartiy, String fullPath, String uri, String key, int orderNumber, boolean sameProject) {
            this.original = original;
            this.translation = translation;
            this.similarity = similartiy;
            this.fullPath = fullPath;
            this.uri = uri;
            this.key = key;
            this.orderNumber = orderNumber;
            this.sameProject = sameProject;
        }

        public String getKey() {
            return this.key;
        }

        public String getOriginal() {
            return this.original;
        }

        public String getTranslation() {
            return this.translation;
        }

        public int getSimilarity() {
            return this.similarity;
        }

        public String getFullPath() {
            return this.fullPath;
        }

        public String getUri() {
            return this.uri;
        }

        public boolean isSameProject() {
            return this.sameProject;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.fullPath == null ? 0 : this.fullPath.hashCode());
            result = 31 * result + (this.uri == null ? 0 : this.uri.hashCode());
            result = 31 * result + (this.original == null ? 0 : this.original.hashCode());
            result = 31 * result + this.similarity;
            result = 31 * result + (this.translation == null ? 0 : this.translation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Similarity other = (Similarity)obj;
            if (this.fullPath == null ? other.fullPath != null : !this.fullPath.equals(other.fullPath)) {
                return false;
            }
            if (this.uri == null ? other.uri != null : !this.uri.equals(other.uri)) {
                return false;
            }
            if (this.original == null ? other.original != null : !this.original.equals(other.original)) {
                return false;
            }
            if (this.similarity != other.similarity) {
                return false;
            }
            return !(this.translation == null ? other.translation != null : !this.translation.equals(other.translation));
        }

        @Override
        public int compareTo(Similarity o) {
            int result = o.getSimilarity() - this.getSimilarity();
            if (result == 0) {
                if (this.equals(o)) {
                    return 0;
                }
                return this.orderNumber - o.orderNumber;
            }
            return result;
        }
    }
}

