/*
 * Decompiled with CFR 0.152.
 */
package org.jabylon.rest.ui.tools;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import javax.inject.Inject;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.AttributeAppender;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.OnDomReadyHeaderItem;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.model.IModel;
import org.jabylon.common.review.TerminologyProvider;
import org.jabylon.properties.Property;
import org.jabylon.rest.ui.model.PropertyPair;
import org.jabylon.rest.ui.wicket.BasicPanel;

public class TerminologyAidToolPanel
extends BasicPanel<PropertyPair> {
    private static final long serialVersionUID = -7220757882567413172L;
    private static final String TERMINOLOGY_DELIMITER = " \t\n\r\f.,;:(){}\"'<>?-";
    private static final Map<String, Property> EMPTY_MAP = new HashMap<String, Property>(0);
    @Inject
    private TerminologyProvider terminologyProvider;
    private static final String JS = "$(\"#terminology-terms i.icon-share\").click(function() {var translation = $(this).prev(\"span\");var widget = $(\"#translation\");if(widget.attr(\"readonly\")!=='readonly') {widget.val(widget.val() + translation.text());markDirty();}});$('#translation').change(function() {\t  var widget = this;\t  $('#terminology-terms i.icon-share').prev('span').each(function(index){\t\t   var result = $(widget).val().indexOf($(this).text());\t\t   if(result>=0) {\t\t\t   $(this).siblings('.label').show();\t\t   }\t\t   else {\t\t\t   $(this).siblings('.label').hide();\t\t   }\t   });});";

    public TerminologyAidToolPanel(String id, IModel<PropertyPair> model) {
        super(id, model);
    }

    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        response.render((HeaderItem)OnDomReadyHeaderItem.forScript((CharSequence)JS));
    }

    @Override
    protected void construct() {
        super.construct();
        Map<String, Property> terminology = this.getTerminology(((PropertyPair)this.getModelObject()).getLanguage());
        List<TerminologyTranslation> result = this.analyze((IModel<PropertyPair>)this.getModel(), terminology);
        ListView<TerminologyTranslation> list = new ListView<TerminologyTranslation>("terms", result){
            private static final long serialVersionUID = 8716974286032849509L;

            protected void populateItem(ListItem<TerminologyTranslation> item) {
                TerminologyTranslation translation = (TerminologyTranslation)item.getModelObject();
                item.add(new Component[]{new Label("term", translation.getTerm())});
                Label translationLabel = new Label("translation", translation.getTranslation());
                item.add(new Component[]{translationLabel});
                Label label = new Label("label", "OK");
                item.add(new Component[]{label});
                String currentTranslation = ((PropertyPair)TerminologyAidToolPanel.this.getModelObject()).getTranslated();
                if (currentTranslation == null || !currentTranslation.contains(translation.getTranslation())) {
                    label.add(new Behavior[]{new AttributeAppender("style", (Serializable)((Object)"display: none;"))});
                }
                if (translation.getComment() != null) {
                    translationLabel.add(new Behavior[]{new AttributeAppender("title", (Serializable)((Object)translation.getComment()))});
                }
            }
        };
        this.add(new Component[]{list});
    }

    private List<TerminologyTranslation> analyze(IModel<PropertyPair> pair, Map<String, Property> terminology) {
        ArrayList<TerminologyTranslation> translations = new ArrayList<TerminologyTranslation>();
        if (terminology == null || terminology.isEmpty() || pair == null || pair.getObject() == null || ((PropertyPair)pair.getObject()).getTemplate() == null) {
            return translations;
        }
        Collection<String> tokens = this.getTokens(((PropertyPair)pair.getObject()).getTemplate().getValue(), terminology);
        for (String term : tokens) {
            Property property = terminology.get(term);
            if (property == null) {
                property = terminology.get(term.toLowerCase());
            }
            if (property == null) continue;
            translations.add(new TerminologyTranslation(property.getKey(), property.getValue(), property.getComment()));
        }
        return translations;
    }

    private Collection<String> getTokens(String value, Map<String, Property> terminology) {
        LinkedHashSet<String> tokens = new LinkedHashSet<String>();
        if (value == null) {
            return tokens;
        }
        StringTokenizer tokenizer = new StringTokenizer(value, TERMINOLOGY_DELIMITER);
        while (tokenizer.hasMoreTokens()) {
            tokens.add(tokenizer.nextToken());
        }
        return tokens;
    }

    private Map<String, Property> getTerminology(Locale locale) {
        if (this.terminologyProvider == null) {
            return EMPTY_MAP;
        }
        return this.terminologyProvider.getTerminology(locale);
    }

    private static class TerminologyTranslation
    implements Serializable {
        private static final long serialVersionUID = 8661310521341467528L;
        private String term;
        private String translation;
        private String comment;

        public TerminologyTranslation(String term, String translation, String comment) {
            this.term = term;
            this.translation = translation;
            this.comment = comment;
        }

        public String getTerm() {
            return this.term;
        }

        public String getTranslation() {
            return this.translation;
        }

        public String getComment() {
            return this.comment;
        }
    }
}

