/*
 * Decompiled with CFR 0.152.
 */
package org.jabylon.rest.ui.wicket;

import java.util.Collections;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.request.Response;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.resource.ResourceReference;
import org.jabylon.rest.ui.util.GlobalResources;

public class FaviconHeaderItem
extends HeaderItem {
    private ResourceReference favicon;

    public FaviconHeaderItem(ResourceReference favicon) {
        this.favicon = favicon;
    }

    public FaviconHeaderItem() {
        this(GlobalResources.IMG_JABYLON_FAVICON);
    }

    public Iterable<?> getRenderTokens() {
        return Collections.singletonList("<link rel=\"shortcut icon\"");
    }

    public void render(Response response) {
        response.write(this.getFavIconReference(RequestCycle.get().urlFor(this.favicon, null)));
    }

    private CharSequence getFavIconReference(CharSequence url) {
        StringBuilder sb = new StringBuilder();
        sb.append("<link rel=\"shortcut icon\" href=\"");
        sb.append(url);
        sb.append("\" type=\"image/x-icon\">\n");
        return sb.toString();
    }
}

