/*
 * Decompiled with CFR 0.152.
 */
package org.jabylon.rest.ui.wicket.components;

import java.util.List;
import org.apache.wicket.Session;
import org.apache.wicket.extensions.ajax.markup.html.tabs.AjaxTabbedPanel;
import org.apache.wicket.extensions.markup.html.tabs.ITab;
import org.apache.wicket.extensions.markup.html.tabs.TabbedPanel;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.model.IModel;
import org.eclipse.emf.ecore.EObject;
import org.jabylon.common.util.PreferencesUtil;
import org.jabylon.rest.ui.security.CDOAuthenticatedSession;
import org.jabylon.users.User;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class BootstrapAjaxTabbedPanel<T extends ITab>
extends AjaxTabbedPanel<T> {
    private static final long serialVersionUID = 2818066082911318768L;
    private String persistenceKey;

    public BootstrapAjaxTabbedPanel(String id, List<T> tabs, String persistenceKey) {
        super(id, tabs);
        this.persistenceKey = persistenceKey;
        if (persistenceKey != null) {
            Preferences prefs = PreferencesUtil.scopeFor((Object)this.getUser());
            int activeTab = prefs.getInt(persistenceKey, 0);
            this.setSelectedTab(activeTab);
        }
    }

    public BootstrapAjaxTabbedPanel(String id, List<T> tabs, IModel<Integer> model, String persistenceKey) {
        super(id, tabs);
        this.setSelectedTab((Integer)model.getObject());
    }

    protected void onComponentTag(ComponentTag tag) {
        super.onComponentTag(tag);
        this.checkComponentTag(tag, "div");
        tag.append("class", (CharSequence)"tabbable", " ");
    }

    protected String getSelectedTabCssClass() {
        return "active";
    }

    protected String getLastTabCssClass() {
        return "";
    }

    public TabbedPanel<T> setSelectedTab(int index) {
        Preferences prefs;
        if (this.persistenceKey != null && index != (prefs = PreferencesUtil.scopeFor((Object)this.getUser())).getInt(this.persistenceKey, -1)) {
            prefs.putInt(this.persistenceKey, index);
            try {
                prefs.flush();
            }
            catch (BackingStoreException e) {
                e.printStackTrace();
            }
        }
        return super.setSelectedTab(index);
    }

    protected EObject getUser() {
        Session session = this.getSession();
        if (session instanceof CDOAuthenticatedSession) {
            CDOAuthenticatedSession authSession = (CDOAuthenticatedSession)session;
            User user = authSession.getUser();
            if (user != null) {
                return user;
            }
            return authSession.getAnonymousUser();
        }
        return null;
    }
}

