/*
 * Decompiled with CFR 0.152.
 */
package org.jabylon.rest.ui.wicket.components;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.feedback.FeedbackMessage;
import org.apache.wicket.feedback.FeedbackMessages;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.border.Border;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.util.iterator.ComponentHierarchyIterator;

public class ControlGroup
extends Border {
    private static final long serialVersionUID = 7523670767478562406L;
    private Label label;
    private Label help;
    private FeedbackMessage feedback;
    private Label feedbackLabel;
    private Label extra;

    public ControlGroup(String id) {
        this(id, (IModel<String>)Model.of((Serializable)((Object)"")), (IModel<String>)Model.of((Serializable)((Object)"")));
    }

    public ControlGroup(String id, IModel<String> label) {
        this(id, label, (IModel<String>)Model.of((Serializable)((Object)"")));
    }

    public ControlGroup(String id, IModel<String> label, IModel<String> help) {
        super(id, (IModel)Model.of((Serializable)((Object)"")));
        this.label = new Label("label", label);
        this.help = new Label("help", help);
        this.extra = new Label("extra-label", "");
        this.extra.setVisible(false);
        this.feedbackLabel = new Label("feedback", (IModel)Model.of((Serializable)((Object)"")));
        this.addToBorder(new Component[]{this.label, this.help, this.feedbackLabel, this.extra});
    }

    public void setExtraLabel(IModel<String> model) {
        this.extra.setVisible(model.getObject() != null && !((String)model.getObject()).isEmpty());
        this.extra.setDefaultModel(model);
    }

    protected void onInitialize() {
        super.onInitialize();
        List<FormComponent<?>> formComponents = this.collectFormComponents();
        for (FormComponent<?> formComponent : formComponents) {
            formComponent.setOutputMarkupId(true);
        }
        int size = formComponents.size();
        if (size > 0) {
            FormComponent<?> formComponent;
            formComponent = formComponents.get(size - 1);
            this.label.add(new Behavior[]{new AttributeModifier("for", (Serializable)((Object)formComponent.getMarkupId()))});
        }
    }

    protected List<FormComponent<?>> collectFormComponents() {
        ComponentHierarchyIterator visitor = this.getBodyContainer().visitChildren(FormComponent.class);
        ArrayList components = new ArrayList();
        while (visitor.hasNext()) {
            Component next = (Component)visitor.next();
            components.add((FormComponent<?>)next);
        }
        return components;
    }

    protected void onConfigure() {
        super.onConfigure();
        this.feedback = this.findWorstMessage();
        if (this.feedback != null) {
            this.feedbackLabel.setDefaultModel((IModel)Model.of((Serializable)this.feedback.getMessage()));
        } else {
            this.feedbackLabel.setDefaultModel((IModel)Model.of((Serializable)((Object)"")));
        }
        this.hideIfEmpty(this.help);
        this.hideIfEmpty(this.feedbackLabel);
    }

    private void hideIfEmpty(Label component) {
        Object content = component.getDefaultModelObject();
        component.setVisible(content != null && !content.toString().isEmpty());
    }

    protected void onComponentTag(ComponentTag tag) {
        super.onComponentTag(tag);
        String stateClass = this.getStateClass(this.feedback);
        tag.put("class", (CharSequence)("control-group" + stateClass));
    }

    protected FeedbackMessage findWorstMessage() {
        List<FormComponent<?>> components = this.collectFormComponents();
        FeedbackMessage worst = null;
        int worstLevel = 0;
        for (FormComponent<?> formComponent : components) {
            FeedbackMessages messages;
            if (!formComponent.hasFeedbackMessage() || (messages = formComponent.getFeedbackMessages()) == null) continue;
            for (FeedbackMessage message : messages) {
                if (message.getLevel() <= worstLevel) continue;
                worstLevel = message.getLevel();
                worst = message;
            }
        }
        return worst;
    }

    protected String getStateClass(FeedbackMessage message) {
        if (message == null) {
            return "";
        }
        switch (message.getLevel()) {
            case 200: {
                return " info";
            }
            case 250: {
                return " success";
            }
            case 300: {
                return " warning";
            }
            case 400: {
                return " error";
            }
        }
        return "";
    }
}

