/*
 * Decompiled with CFR 0.152.
 */
package org.jabylon.rest.ui.wicket.components;

import java.io.Serializable;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.AjaxSelfUpdatingTimerBehavior;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.WebComponent;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.time.Duration;
import org.eclipse.core.runtime.IStatus;
import org.jabylon.common.progress.Progression;
import org.jabylon.rest.ui.Activator;
import org.jabylon.rest.ui.model.ProgressionModel;
import org.jabylon.rest.ui.wicket.components.CustomFeedbackPanel;
import org.jabylon.rest.ui.wicket.components.ProgressCallback;

public class ProgressPanel
extends Panel {
    private ProgressionModel model;
    private boolean started;
    private CustomFeedbackPanel feedbackPanel;
    private WebMarkupContainer container;
    private static final long serialVersionUID = 2573454585436627297L;

    public ProgressPanel(String id, ProgressionModel model) {
        super(id, (IModel)model);
        this.model = model;
        this.feedbackPanel = new CustomFeedbackPanel("feedbackPanel");
        this.add(new Component[]{this.feedbackPanel});
        this.container = new WebMarkupContainer("container");
        this.add(new Component[]{this.container});
        WebComponent bar = new WebComponent("bar");
        bar.add(new Behavior[]{new AttributeModifier("style", this.getWidthModel(model))});
        this.container.add(new Component[]{bar});
        Label taskname = new Label("taskname", this.getTaskNameModel(model));
        this.container.add(new Component[]{taskname});
        Label subtask = new Label("subtask", this.getSubTaskModel(model));
        this.container.add(new Component[]{subtask});
        this.setVisible(false);
        this.container.add(new Component[]{new AjaxLink<Void>("cancel"){
            private static final long serialVersionUID = 3623515953111747368L;

            public void onClick(AjaxRequestTarget target) {
                Activator.getDefault().getProgressService().cancel(ProgressPanel.this.model.getId());
            }
        }});
    }

    private IModel<String> getWidthModel(final IModel<Progression> model) {
        return new AbstractReadOnlyModel<String>(){
            private static final long serialVersionUID = 1L;

            public String getObject() {
                int width = model.getObject() == null ? 0 : ((Progression)model.getObject()).getCompletion();
                return "width: " + width + "%;";
            }
        };
    }

    private IModel<String> getTaskNameModel(final IModel<Progression> model) {
        return new AbstractReadOnlyModel<String>(){
            private static final long serialVersionUID = 1L;

            public String getObject() {
                if (model.getObject() != null) {
                    return ((Progression)model.getObject()).getTaskName();
                }
                return "";
            }
        };
    }

    private IModel<String> getSubTaskModel(final IModel<Progression> model) {
        return new AbstractReadOnlyModel<String>(){
            private static final long serialVersionUID = 1L;

            public String getObject() {
                if (model.getObject() != null) {
                    return ((Progression)model.getObject()).getSubTaskName();
                }
                return "";
            }
        };
    }

    public void start(AjaxRequestTarget target, final ProgressCallback callback) {
        this.setVisible(true);
        this.container.setVisible(true);
        this.add(new Behavior[]{new AjaxSelfUpdatingTimerBehavior(Duration.ONE_SECOND){
            private static final long serialVersionUID = 1L;

            protected void onPostProcessTarget(AjaxRequestTarget target) {
                if (!ProgressPanel.this.started && callback != null) {
                    callback.progressStart(target, ProgressPanel.this.getModel());
                    ProgressPanel.this.started = true;
                }
                ProgressionModel model = ProgressPanel.this.getModel();
                callback.progressStart(target, model);
                Progression progression = model.getObject();
                if (progression == null || progression.isDone()) {
                    this.stop(target);
                    if (progression != null && !progression.getStatus().isOK()) {
                        ProgressPanel.this.addFeedbackMessage(progression.getStatus());
                        ProgressPanel.this.container.setVisible(false);
                    } else {
                        ProgressPanel.this.setVisible(false);
                    }
                    if (callback != null) {
                        callback.progressDone(target, ProgressPanel.this.getModel());
                    }
                }
            }
        }});
        if (this.getParent() != null) {
            target.add(new Component[]{this.getParent()});
        } else if (target != null) {
            target.add(new Component[]{this});
        }
    }

    public void start() {
        this.setVisible(true);
        this.container.setVisible(true);
        this.add(new Behavior[]{new AjaxSelfUpdatingTimerBehavior(Duration.ONE_SECOND){
            private static final long serialVersionUID = 1L;

            protected void onPostProcessTarget(AjaxRequestTarget target) {
                ProgressPanel.this.started = true;
                ProgressionModel model = ProgressPanel.this.getModel();
                Progression progression = model.getObject();
                if (progression == null || progression.isDone()) {
                    this.stop(target);
                    if (!progression.getStatus().isOK()) {
                        ProgressPanel.this.addFeedbackMessage(progression.getStatus());
                        ProgressPanel.this.container.setVisible(false);
                    } else {
                        ProgressPanel.this.setVisible(false);
                    }
                }
            }
        }});
    }

    protected void addFeedbackMessage(IStatus status) {
        if (status == null) {
            return;
        }
        String message = status.getMessage();
        if (status.getException() != null && status.getException().getMessage() != null) {
            message = message == null || message.isEmpty() ? status.getException().getMessage() : message + " : " + status.getException().getMessage();
        }
        if (message == null) {
            return;
        }
        switch (status.getSeverity()) {
            case 1: {
                this.feedbackPanel.info((Serializable)((Object)message));
                break;
            }
            case 4: {
                this.feedbackPanel.error((Serializable)((Object)message));
                break;
            }
            case 2: {
                this.feedbackPanel.warn((Serializable)((Object)message));
                break;
            }
            case 0: {
                this.feedbackPanel.success((Serializable)((Object)message));
                break;
            }
        }
    }

    public ProgressionModel getModel() {
        return this.model;
    }
}

