/*
 * Decompiled with CFR 0.152.
 */
package org.jabylon.rest.ui.wicket.components;

import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.form.AjaxButton;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.model.IModel;
import org.jabylon.common.progress.RunnableWithProgress;
import org.jabylon.rest.ui.Activator;
import org.jabylon.rest.ui.model.ProgressionModel;
import org.jabylon.rest.ui.wicket.components.ProgressCallback;
import org.jabylon.rest.ui.wicket.components.ProgressPanel;

public class ProgressShowingAjaxButton
extends AjaxButton
implements ProgressCallback {
    private static final long serialVersionUID = 1L;
    private ProgressPanel panel;
    private RunnableWithProgress runnable;
    private IModel<String> taskName;

    public ProgressShowingAjaxButton(String id, ProgressPanel panel, RunnableWithProgress runnable, IModel<String> taskName) {
        super(id);
        this.panel = panel;
        this.taskName = taskName;
        this.runnable = runnable;
        this.setDefaultFormProcessing(false);
    }

    protected void onSubmit(AjaxRequestTarget target, Form<?> form) {
        super.onSubmit(target, form);
        this.panel.start(target, this);
        this.setEnabled(false);
        String id = Activator.getDefault().getProgressService().schedule(this.runnable, (String)this.taskName.getObject());
        this.panel.getModel().setTaskID(id);
    }

    @Override
    public void progressStart(AjaxRequestTarget target, ProgressionModel model) {
        target.add(new Component[]{this});
    }

    @Override
    public void progressDone(AjaxRequestTarget target, ProgressionModel model) {
        this.setEnabled(true);
    }
}

