/*
 * Decompiled with CFR 0.152.
 */
package org.jabylon.rest.ui.wicket.components;

import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.AttributeAppender;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.image.Image;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.request.Url;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.request.resource.UrlResourceReference;
import org.jabylon.rest.ui.wicket.components.MD5Util;
import org.jabylon.users.User;

public class UserImagePanel
extends Panel {
    private static final String GRAVATAR_BASE_URL = "https://www.gravatar.com/avatar/";
    private static final int DEFAULT_SIZE = 30;
    private static final int LARGE_SIZE = 120;
    private int size = 30;
    private static final long serialVersionUID = 1L;

    public UserImagePanel(String id, IModel<User> model) {
        this(id, model, false);
    }

    public UserImagePanel(String id, IModel<User> model, boolean large) {
        super(id, model);
        Label name = new Label("name", this.getUsername(model));
        this.add(new Component[]{name});
        if (large) {
            name.add(new Behavior[]{new AttributeAppender("style", (Serializable)((Object)"font-size: large;"))});
            this.size = 120;
        }
        Image image = new Image("image", this.getImageUrl(model));
        if (large) {
            image.add(new Behavior[]{new AttributeAppender("class", (Serializable)((Object)"img-polaroid"))});
        }
        this.add(new Component[]{image});
    }

    private String getUsername(IModel<User> model) {
        String username = "none";
        if (model.getObject() != null && ((username = ((User)model.getObject()).getDisplayName()) == null || username.isEmpty())) {
            username = ((User)model.getObject()).getName();
        }
        return username;
    }

    private ResourceReference getImageUrl(IModel<User> model) {
        String email = this.getEMail(model);
        if (email == null) {
            email = ((User)model.getObject()).toString();
        }
        Url url = Url.parse((CharSequence)(GRAVATAR_BASE_URL + MD5Util.md5Hex(this.normalize(email))));
        url.addQueryParameter("size", (Object)this.size);
        url.addQueryParameter("d", (Object)"wavatar");
        return new UrlResourceReference(url);
    }

    private String normalize(String email) {
        return email.trim().toLowerCase(this.getSession().getLocale());
    }

    private String getEMail(IModel<User> model) {
        if (model.getObject() == null) {
            return null;
        }
        return ((User)model.getObject()).getEmail();
    }
}

