/*
 * Decompiled with CFR 0.152.
 */
package org.jabylon.rest.ui.wicket.config;

import java.io.Serializable;
import org.apache.wicket.markup.html.link.AbstractLink;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.markup.html.link.ExternalLink;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.request.resource.ResourceReference;
import org.jabylon.rest.ui.util.GlobalResources;
import org.jabylon.rest.ui.util.WicketUtil;
import org.jabylon.rest.ui.wicket.config.SettingsPage;

enum ConfigKind {
    WORKSPACE("projects.title", "projects.description", GlobalResources.IMG_WORKSPACE_SETTINGS){

        public Link<Void> constructLink(String id) {
            PageParameters params = new PageParameters();
            params.set(0, (Object)"workspace");
            BookmarkablePageLink link = new BookmarkablePageLink(id, SettingsPage.class, params);
            return link;
        }
    }
    ,
    SYSTEM("system.title", "system.description", GlobalResources.IMG_SYSTEM_SETTINGS){

        @Override
        public AbstractLink constructLink(String id) {
            return new ExternalLink(id, (IModel)Model.of((Serializable)((Object)(WicketUtil.getContextPath() + "/settings/system"))));
        }
    }
    ,
    LOGGING("logging.title", "logging.description", GlobalResources.IMG_LOG_SETTINGS){

        @Override
        public AbstractLink constructLink(String id) {
            return new ExternalLink(id, (IModel)Model.of((Serializable)((Object)(WicketUtil.getContextPath() + "/settings/log"))));
        }
    }
    ,
    SECURITY("security.title", "security.description", GlobalResources.IMG_SECURITY_SETTINGS){

        @Override
        public AbstractLink constructLink(String id) {
            PageParameters params = new PageParameters();
            params.set(0, (Object)"security");
            BookmarkablePageLink link = new BookmarkablePageLink(id, SettingsPage.class, params);
            return link;
        }
    };

    private String name;
    private String description;
    private ResourceReference icon;

    private ConfigKind(String name, String description, ResourceReference icon) {
        this.name = name;
        this.description = description;
        this.icon = icon;
    }

    public String getDescription() {
        return this.description;
    }

    public String getName() {
        return this.name;
    }

    public ResourceReference getIcon() {
        return this.icon;
    }

    public abstract AbstractLink constructLink(String var1);
}

