/*
 * Decompiled with CFR 0.152.
 */
package org.jabylon.rest.ui.wicket.config;

import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.GenericPanel;
import org.apache.wicket.model.IModel;
import org.eclipse.emf.cdo.CDOObject;
import org.jabylon.rest.ui.security.CDOAuthenticatedSession;
import org.jabylon.rest.ui.wicket.config.ConfigSection;
import org.jabylon.users.User;
import org.osgi.service.prefs.Preferences;

public class ConfigTabPanel<T extends CDOObject>
extends GenericPanel<T> {
    private static final long serialVersionUID = 1L;

    public ConfigTabPanel(String id, List<ConfigSection<T>> sections, final IModel<T> model, final Preferences preferences) {
        super(id, model);
        ListView view = new ListView<ConfigSection<T>>("sections", sections){
            private static final long serialVersionUID = 1L;

            protected void populateItem(ListItem<ConfigSection<T>> arg0) {
                ConfigSection object = (ConfigSection)arg0.getModelObject();
                WebMarkupContainer container = object.createContents("content", model, preferences);
                arg0.add(new Component[]{container});
                container.setVisibilityAllowed(ConfigTabPanel.this.hasPermission(object));
            }
        };
        view.setReuseItems(true);
        this.add(new Component[]{view});
    }

    private boolean hasPermission(ConfigSection<T> object) {
        User user = ((CDOAuthenticatedSession)CDOAuthenticatedSession.get()).getUser();
        if (user == null) {
            return false;
        }
        return user.hasPermission(object.getRequiredPermission());
    }
}

