/*
 * Decompiled with CFR 0.152.
 */
package org.jabylon.rest.ui.wicket.config;

import com.google.common.collect.ArrayListMultimap;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.apache.wicket.Component;
import org.apache.wicket.RestartResponseAtInterceptPageException;
import org.apache.wicket.authorization.UnauthorizedInstantiationException;
import org.apache.wicket.extensions.markup.html.tabs.ITab;
import org.apache.wicket.markup.html.form.Button;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.panel.GenericPanel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.StringResourceModel;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.util.string.StringValue;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.CDOState;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.util.CommitException;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.jabylon.common.resolver.URIResolver;
import org.jabylon.common.util.AttachablePreferences;
import org.jabylon.common.util.DelegatingPreferences;
import org.jabylon.common.util.PreferencesUtil;
import org.jabylon.common.util.config.DynamicConfigUtil;
import org.jabylon.rest.ui.model.AttachableModel;
import org.jabylon.rest.ui.model.AttachableWritableModel;
import org.jabylon.rest.ui.security.CDOAuthenticatedSession;
import org.jabylon.rest.ui.security.LoginPage;
import org.jabylon.rest.ui.util.WicketUtil;
import org.jabylon.rest.ui.wicket.components.ClientSideTabbedPanel;
import org.jabylon.rest.ui.wicket.config.ConfigSection;
import org.jabylon.rest.ui.wicket.config.ConfigTab;
import org.jabylon.rest.ui.wicket.config.SettingsPage;
import org.jabylon.users.User;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SettingsPanel<T extends CDOObject>
extends GenericPanel<T> {
    public static final String QUERY_PARAM_NAMESPACE = "namespace";
    private static final long serialVersionUID = 1L;
    public static final String QUERY_PARAM_CREATE = "create";
    private static final Logger logger = LoggerFactory.getLogger(SettingsPage.class);
    private List<ConfigSection<?>> allSections;
    @Inject
    private URIResolver resolver;

    public SettingsPanel(String id, IModel<T> model, PageParameters pageParameters) {
        super(id, model);
        CDOObject modelObject;
        EClass eclass = this.getEClassToCreate(pageParameters);
        if (eclass != null) {
            this.setModel(new AttachableWritableModel(eclass, (IModel<? extends CDOObject>)this.getModel()));
        }
        boolean isNew = (modelObject = (CDOObject)this.getModelObject()).cdoState() == CDOState.NEW || modelObject.cdoState() == CDOState.TRANSIENT;
        final Preferences preferences = (Preferences)(isNew ? new AttachablePreferences() : new DelegatingPreferences(PreferencesUtil.scopeFor((Object)modelObject)));
        final List<ITab> extensions = this.loadTabExtensions(preferences);
        Form form = new Form("form", this.getModel()){
            private static final long serialVersionUID = 1L;

            protected void onSubmit() {
                Preferences prefs;
                CDOTransaction transaction;
                CDOView cdoView;
                IModel model = SettingsPanel.this.getModel();
                CDOObject object = (CDOObject)model.getObject();
                if (model instanceof AttachableModel) {
                    AttachableModel attachable = (AttachableModel)model;
                    attachable.attach();
                    CDOObject parent = (CDOObject)((CDOObject)attachable.getObject()).eContainer();
                    cdoView = parent.cdoView();
                } else {
                    cdoView = object.cdoView();
                }
                if (cdoView instanceof CDOTransaction) {
                    transaction = (CDOTransaction)cdoView;
                    prefs = preferences;
                    if (preferences instanceof AttachablePreferences) {
                        Preferences targetPrefs = PreferencesUtil.scopeFor((Object)object);
                        try {
                            PreferencesUtil.cloneNode((Preferences)preferences, (Preferences)targetPrefs);
                            prefs = targetPrefs;
                        }
                        catch (BackingStoreException e) {
                            this.error((Serializable)((Object)("Some settings could not be saved: " + e.getMessage())));
                            logger.error("Failed to attach preferences to target path", (Throwable)e);
                        }
                    }
                } else {
                    throw new IllegalStateException("not a transaction");
                }
                this.commit(prefs, object, transaction);
                super.onSubmit();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void commit(Preferences preferences2, CDOObject object, CDOTransaction transaction) {
                for (ConfigSection section : SettingsPanel.this.allSections) {
                    section.commit(this.getModel(), preferences2);
                }
                try {
                    transaction.commit();
                    URI uri = SettingsPanel.this.resolver.getURI((Object)object);
                    this.setResponsePage(SettingsPage.class, WicketUtil.buildPageParametersFor(uri));
                    preferences2.flush();
                    this.getSession().success((Serializable)((Object)this.getString("save.success.feedback.message")));
                }
                catch (CommitException e) {
                    this.getSession().error((Serializable)((Object)e.getMessage()));
                    logger.error("failed to commit configuration for " + object, (Throwable)e);
                }
                catch (BackingStoreException e) {
                    this.getSession().error((Serializable)((Object)e.getMessage()));
                    logger.error("failed to commit configuration for " + object, (Throwable)e);
                }
            }
        };
        ClientSideTabbedPanel<ITab> tabContainer = new ClientSideTabbedPanel<ITab>("tabs", extensions, false, "settings/" + ((CDOObject)model.getObject()).getClass().getSimpleName()){
            private static final long serialVersionUID = 1L;

            public boolean isVisible() {
                boolean visible = super.isVisible();
                List tabContents = extensions;
                for (ITab component : tabContents) {
                    if (!component.isVisible()) continue;
                    return visible;
                }
                CDOAuthenticatedSession session = (CDOAuthenticatedSession)CDOAuthenticatedSession.get();
                User user = session.getUser();
                if (user == null || "Anonymous".equals(user.getName())) {
                    throw new RestartResponseAtInterceptPageException(LoginPage.class);
                }
                throw new UnauthorizedInstantiationException(SettingsPanel.class);
            }
        };
        form.add(new Component[]{tabContainer});
        Button submitButton = new Button("submit", (IModel)new StringResourceModel("submit.button.label", (Component)this, null, new Object[0]));
        form.add(new Component[]{submitButton});
        this.add(new Component[]{form});
    }

    private EClass getEClassToCreate(PageParameters pageParameters) {
        EClassifier eClassifier;
        String namespace;
        EPackage ePackage;
        StringValue value = pageParameters.get(QUERY_PARAM_CREATE);
        if (value != null && !value.isEmpty() && (ePackage = EPackage.Registry.INSTANCE.getEPackage(namespace = pageParameters.get(QUERY_PARAM_NAMESPACE).toString("http://uri.jabylon.org/properties"))) != null && (eClassifier = ePackage.getEClassifier(value.toString())) instanceof EClass) {
            EClass eclass = (EClass)eClassifier;
            return eclass;
        }
        return null;
    }

    private List<ITab> loadTabExtensions(Preferences preferences) {
        List configurationElements = DynamicConfigUtil.getConfigTabs();
        ArrayListMultimap sections = ArrayListMultimap.create((int)configurationElements.size(), (int)5);
        this.allSections = new ArrayList();
        List elements = DynamicConfigUtil.getApplicableElements((Object)this.getModelObject());
        for (IConfigurationElement element : elements) {
            String id = element.getAttribute("tab");
            try {
                ConfigSection extension = (ConfigSection)element.createExecutableExtension("section");
                sections.put((Object)id, (Object)extension);
            }
            catch (CoreException e) {
                logger.error("Failed to create executable extension: " + element, (Throwable)e);
            }
        }
        ArrayList<ITab> extensions = new ArrayList<ITab>();
        CDOObject modelObject = (CDOObject)this.getModelObject();
        for (IConfigurationElement element : configurationElements) {
            String name = element.getAttribute("name");
            String id = element.getAttribute("tabID");
            List tabSections = sections.removeAll((Object)id);
            ConfigTab tab = new ConfigTab(name, tabSections, this.getModel(), preferences);
            this.allSections.addAll(tabSections);
            if (!tab.isVisible()) continue;
            extensions.add(tab);
        }
        if (!sections.isEmpty()) {
            logger.warn("Unmapped config sections left {}", (Object)sections);
        }
        return extensions;
    }
}

