/*
 * Decompiled with CFR 0.152.
 */
package org.jabylon.rest.ui.wicket.config.sections;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.model.IModel;
import org.eclipse.emf.common.util.URI;
import org.jabylon.common.util.PreferencesUtil;
import org.jabylon.properties.Project;
import org.jabylon.properties.ProjectVersion;
import org.jabylon.properties.PropertiesFactory;
import org.jabylon.properties.Property;
import org.jabylon.properties.PropertyFile;
import org.jabylon.properties.Resolvable;
import org.jabylon.properties.ScanConfiguration;
import org.jabylon.properties.types.impl.POHelper;
import org.jabylon.properties.util.PropertiesResourceImpl;
import org.jabylon.rest.ui.model.AttachableModel;
import org.jabylon.rest.ui.wicket.config.AbstractConfigSection;
import org.jabylon.rest.ui.wicket.config.sections.ProjectConfigSection;
import org.jabylon.security.CommonPermissions;
import org.osgi.service.prefs.Preferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeneralProjectConfig
extends AbstractConfigSection<Project> {
    private static final long serialVersionUID = 1L;
    private static final Collection<String> TERMINOLOGY_LANGUAGES = new ArrayList<String>();
    private static final Logger LOGGER = LoggerFactory.getLogger(GeneralProjectConfig.class);
    private static final String TERMINOLOGY_DOWNLOAD_URL = "http://pootle.locamotion.org/export/terminology/{0}/essential.po";

    @Override
    public WebMarkupContainer doCreateContents(String id, IModel<Project> input, Preferences prefs) {
        return new ProjectConfigSection(id, input);
    }

    @Override
    public void commit(IModel<Project> input, Preferences config) {
        if (input instanceof AttachableModel && ((Project)input.getObject()).isTerminology()) {
            try {
                this.createTerminologyProject((Project)input.getObject());
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to create template project", e);
            }
        }
    }

    private void createTerminologyProject(Project parent) throws IOException {
        ProjectVersion version = PropertiesFactory.eINSTANCE.createProjectVersion();
        version.setName("master");
        version.setParent((Resolvable)parent);
        URL url = new URL(MessageFormat.format(TERMINOLOGY_DOWNLOAD_URL, "de"));
        this.createMessageFile(url.openStream(), version.absoluteFilePath().appendSegment("messages.properties"), true);
        for (String language : TERMINOLOGY_LANGUAGES) {
            url = new URL(MessageFormat.format(TERMINOLOGY_DOWNLOAD_URL, language));
            this.createMessageFile(url.openStream(), version.absoluteFilePath().appendSegment("messages_" + language + ".properties"), false);
        }
        ScanConfiguration scanConfiguration = PreferencesUtil.getScanConfigForProject((Project)parent);
        version.fullScan(scanConfiguration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createMessageFile(InputStream in, URI target, boolean isTemplate) throws IOException {
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(in, "UTF-8"));
            Property property = null;
            POHelper helper = new POHelper();
            PropertyFile file = PropertiesFactory.eINSTANCE.createPropertyFile();
            while ((property = helper.readProperty(reader)) != null) {
                if (isTemplate) {
                    property.setValue(property.getKey());
                    property.setComment(null);
                }
                file.getProperties().add((Object)property);
            }
            PropertiesResourceImpl resource = new PropertiesResourceImpl(target);
            resource.getContents().add((Object)file);
            resource.save(new HashMap());
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        finally {
            reader.close();
        }
    }

    @Override
    public String getRequiredPermission() {
        String projectName = null;
        if (this.getDomainObject() != null) {
            projectName = ((Project)this.getDomainObject()).getName();
        }
        return CommonPermissions.constructPermission((String[])new String[]{"Project", projectName, "edit"});
    }

    static {
        TERMINOLOGY_LANGUAGES.add("de");
        TERMINOLOGY_LANGUAGES.add("fr");
        TERMINOLOGY_LANGUAGES.add("es");
        TERMINOLOGY_LANGUAGES.add("it");
    }
}

