/*
 * Decompiled with CFR 0.152.
 */
package org.jabylon.rest.ui.wicket.config.sections;

import java.util.List;
import javax.inject.Inject;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.repeater.RepeatingView;
import org.apache.wicket.model.IModel;
import org.jabylon.common.review.ReviewParticipant;
import org.jabylon.properties.Project;
import org.jabylon.rest.ui.model.BooleanPreferencesPropertyModel;
import org.jabylon.rest.ui.wicket.BasicPanel;
import org.jabylon.rest.ui.wicket.config.AbstractConfigSection;
import org.jabylon.security.CommonPermissions;
import org.osgi.service.prefs.Preferences;

public class TranslationChecksConfigSection
extends BasicPanel<Project> {
    private static final long serialVersionUID = 1L;
    @Inject
    private List<ReviewParticipant> participants;

    public TranslationChecksConfigSection(String id, IModel<Project> model, Preferences prefs) {
        super(id, model);
        RepeatingView repeater = new RepeatingView("checks");
        if (this.participants != null) {
            for (ReviewParticipant participant : this.participants) {
                WebMarkupContainer container = new WebMarkupContainer(repeater.newChildId());
                repeater.add(new Component[]{container});
                BooleanPreferencesPropertyModel propertyModel = new BooleanPreferencesPropertyModel(prefs, participant.getID(), false);
                CheckBox checkBox = new CheckBox("check", (IModel)propertyModel);
                container.add(new Component[]{new Label("check-label", (IModel)this.nls(participant.getClass(), participant.getName(), new Object[0]))});
                container.add(new Component[]{checkBox});
                container.add(new Component[]{new Label("description", (IModel)this.nls(participant.getClass(), participant.getDescription(), new Object[0]))});
            }
        }
        this.add(new Component[]{repeater});
    }

    public static class TranslationChecksConfig
    extends AbstractConfigSection<Project> {
        private static final long serialVersionUID = 1L;

        @Override
        public WebMarkupContainer doCreateContents(String id, IModel<Project> input, Preferences prefs) {
            return new TranslationChecksConfigSection(id, input, prefs.node("checks"));
        }

        @Override
        public void commit(IModel<Project> input, Preferences config) {
        }

        @Override
        public String getRequiredPermission() {
            String projectName = null;
            if (this.getDomainObject() != null) {
                projectName = ((Project)this.getDomainObject()).getName();
            }
            return CommonPermissions.constructPermission((String[])new String[]{"Project", projectName, "edit"});
        }
    }
}

