/*
 * Decompiled with CFR 0.152.
 */
package org.jabylon.rest.ui.wicket.config.sections;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.ajax.markup.html.form.AjaxSubmitLink;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.form.ListChoice;
import org.apache.wicket.markup.html.form.RequiredTextField;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.util.ListModel;
import org.apache.wicket.validation.IValidator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.jabylon.properties.Project;
import org.jabylon.properties.ProjectLocale;
import org.jabylon.properties.ProjectVersion;
import org.jabylon.properties.PropertiesFactory;
import org.jabylon.properties.PropertiesPackage;
import org.jabylon.properties.util.PropertyResourceUtil;
import org.jabylon.rest.ui.model.AttachableModel;
import org.jabylon.rest.ui.model.EObjectPropertyModel;
import org.jabylon.rest.ui.wicket.BasicPanel;
import org.jabylon.rest.ui.wicket.components.ControlGroup;
import org.jabylon.rest.ui.wicket.config.AbstractConfigSection;
import org.jabylon.rest.ui.wicket.validators.UniqueNameValidator;
import org.jabylon.security.CommonPermissions;
import org.osgi.service.prefs.Preferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VersionConfigSection
extends BasicPanel<ProjectVersion> {
    private static final String TEMPLATE_ID = "template";
    private static final long serialVersionUID = 1L;
    private ListModel<String> choiceModel;

    public VersionConfigSection(String id, IModel<ProjectVersion> model, ListModel<String> locales, Preferences prefs) {
        super(id, model);
        EObjectPropertyModel nameProperty = new EObjectPropertyModel(model, (EStructuralFeature)PropertiesPackage.Literals.RESOLVABLE__NAME);
        RequiredTextField field = new RequiredTextField("inputName", nameProperty);
        field.add((IValidator)UniqueNameValidator.fromCollection(this.getBranches(model), (EStructuralFeature)PropertiesPackage.Literals.RESOLVABLE__NAME, (EObject)model.getObject()));
        this.add(new Component[]{field});
        ControlGroup readOnlyGroup = new ControlGroup("readonly-group", null, (IModel<String>)this.nls("readonly.help", new Object[0]));
        CheckBox readonly = new CheckBox("readonly", new EObjectPropertyModel(model, (EStructuralFeature)PropertiesPackage.Literals.PROJECT_VERSION__READ_ONLY));
        readOnlyGroup.add(new Component[]{readonly});
        this.add(new Component[]{readOnlyGroup});
        final WebMarkupContainer rowPanel = new WebMarkupContainer("rowPanel");
        rowPanel.setOutputMarkupId(true);
        this.add(new Component[]{rowPanel});
        Form form = new Form("locale-form");
        form.setOutputMarkupId(true);
        rowPanel.add(new Component[]{form});
        final TextField languageField = new TextField("inputLanguage", (IModel)Model.of((Serializable)((Object)"")));
        languageField.setOutputMarkupId(true);
        form.add(new Component[]{languageField});
        final TextField countryField = new TextField("inputCountry", (IModel)Model.of((Serializable)((Object)"")));
        countryField.setOutputMarkupId(true);
        form.add(new Component[]{countryField});
        final TextField variantField = new TextField("inputVariant", (IModel)Model.of((Serializable)((Object)"")));
        variantField.setOutputMarkupId(true);
        form.add(new Component[]{variantField});
        this.choiceModel = locales;
        final ListChoice choice = new ListChoice("children", this.choiceModel);
        choice.setModel((IModel)(((List)this.choiceModel.getObject()).isEmpty() ? Model.of((Serializable)((Object)"")) : Model.of((Serializable)((Serializable)((List)this.choiceModel.getObject()).get(0)))));
        choice.setMaxRows(15);
        choice.add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("onchange"){
            private static final long serialVersionUID = 1L;

            protected void onUpdate(AjaxRequestTarget target) {
                target.add(new Component[]{languageField});
                target.add(new Component[]{countryField});
                target.add(new Component[]{variantField});
                String localeString = (String)choice.getModelObject();
                if (localeString == null || VersionConfigSection.TEMPLATE_ID.equals(localeString)) {
                    languageField.setModelObject((Object)"");
                    countryField.setModelObject((Object)"");
                    variantField.setModelObject((Object)"");
                } else {
                    Locale locale = (Locale)PropertiesFactory.eINSTANCE.createFromString(PropertiesPackage.Literals.LOCALE, localeString);
                    languageField.setModelObject((Object)locale.getLanguage());
                    countryField.setModelObject((Object)locale.getCountry());
                    variantField.setModelObject((Object)locale.getVariant());
                }
            }
        }});
        choice.setChoiceRenderer((IChoiceRenderer)new IChoiceRenderer<String>(){
            private static final long serialVersionUID = 1L;

            public Object getDisplayValue(String object) {
                if (VersionConfigSection.TEMPLATE_ID.equals(object)) {
                    return "Template";
                }
                Locale locale = (Locale)PropertiesFactory.eINSTANCE.createFromString(PropertiesPackage.Literals.LOCALE, object);
                String displayName = locale == null ? "Template" : locale.getDisplayName(VersionConfigSection.this.getSession().getLocale());
                return displayName;
            }

            public String getIdValue(String locale, int index) {
                if (locale == null) {
                    return VersionConfigSection.TEMPLATE_ID;
                }
                return locale.toString();
            }
        });
        rowPanel.add(new Component[]{choice});
        AjaxSubmitLink addLink = new AjaxSubmitLink("addLocale", form){
            private static final long serialVersionUID = 1L;

            public void onSubmit(AjaxRequestTarget target, Form<?> form) {
                Locale locale = new Locale(VersionConfigSection.this.safeGet((String)languageField.getModelObject()), VersionConfigSection.this.safeGet((String)countryField.getModelObject()), VersionConfigSection.this.safeGet((String)variantField.getModelObject()));
                if (!((List)VersionConfigSection.this.choiceModel.getObject()).contains(locale.toString())) {
                    ((List)VersionConfigSection.this.choiceModel.getObject()).add(locale.toString());
                }
                choice.setModelObject((Object)locale.toString());
                if (target != null) {
                    target.add(new Component[]{rowPanel});
                }
            }
        };
        form.add(new Component[]{addLink});
        AjaxSubmitLink removeLink = new AjaxSubmitLink("removeLocale", form){
            private static final long serialVersionUID = 1L;

            public void onSubmit(AjaxRequestTarget target, Form<?> form) {
                ((List)VersionConfigSection.this.choiceModel.getObject()).remove(choice.getModelObject());
                if (target != null) {
                    target.add(new Component[]{rowPanel});
                }
            }
        };
        form.add(new Component[]{removeLink});
    }

    public Collection<ProjectVersion> getBranches(IModel<ProjectVersion> current) {
        if (current == null) {
            return Collections.emptyList();
        }
        Project parent = (Project)((ProjectVersion)current.getObject()).getParent();
        if (parent == null && current instanceof AttachableModel) {
            AttachableModel model = (AttachableModel)current;
            parent = (Project)model.getParent().getObject();
        }
        if (parent == null) {
            return Collections.emptyList();
        }
        return parent.getChildren();
    }

    private String safeGet(String s) {
        if (s != null) {
            return s;
        }
        return "";
    }

    public static class VersionConfig
    extends AbstractConfigSection<ProjectVersion> {
        private static final long serialVersionUID = 1L;
        private static final Logger LOGGER = LoggerFactory.getLogger(VersionConfig.class);
        private ListModel<String> locales;

        @Override
        public WebMarkupContainer doCreateContents(String id, IModel<ProjectVersion> input, Preferences prefs) {
            this.locales = this.createListModel(input);
            return new VersionConfigSection(id, input, this.locales, prefs);
        }

        @Override
        public void commit(IModel<ProjectVersion> input, Preferences config) {
            this.applyLocaleList((List)this.locales.getObject(), input);
        }

        protected void applyLocaleList(List<String> object, IModel<ProjectVersion> input) {
            HashSet<String> locales = new HashSet<String>(object);
            ProjectVersion version = (ProjectVersion)input.getObject();
            Iterator iterator = version.getChildren().iterator();
            while (iterator.hasNext()) {
                ProjectLocale projectLocale = (ProjectLocale)iterator.next();
                if (projectLocale.isMaster() || locales.remove(projectLocale.getName())) continue;
                LOGGER.info("Deleting ProjectLocale {} from {}", (Object)projectLocale.getName(), (Object)version.fullPath());
                iterator.remove();
            }
            for (String locale : locales) {
                ProjectLocale projectLocale = PropertiesFactory.eINSTANCE.createProjectLocale();
                projectLocale.setLocale((Locale)PropertiesFactory.eINSTANCE.createFromString(PropertiesPackage.Literals.LOCALE, locale));
                LOGGER.info("Adding ProjectLocale {} to {}", (Object)projectLocale.getName(), (Object)version.fullPath());
                PropertyResourceUtil.addNewLocale((ProjectLocale)projectLocale, (ProjectVersion)((ProjectVersion)input.getObject()));
            }
        }

        private ListModel<String> createListModel(IModel<ProjectVersion> parent) {
            ProjectVersion projectVersion = (ProjectVersion)parent.getObject();
            EList children = projectVersion.getChildren();
            ArrayList<String> list = new ArrayList<String>(children.size());
            for (ProjectLocale projectLocale : children) {
                if (projectLocale.isMaster()) continue;
                list.add(projectLocale.getName());
            }
            return new ListModel(list);
        }

        @Override
        public String getRequiredPermission() {
            String projectName = null;
            if (this.getDomainObject() != null && ((ProjectVersion)this.getDomainObject()).getParent() != null) {
                projectName = ((Project)((ProjectVersion)this.getDomainObject()).getParent()).getName();
            }
            return CommonPermissions.constructPermission((String[])new String[]{"Project", projectName, "edit"});
        }
    }
}

