/*
 * Decompiled with CFR 0.152.
 */
package org.jabylon.rest.ui.wicket.config.sections.security;

import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Button;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.CDOState;
import org.eclipse.emf.cdo.util.CommitException;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.jabylon.cdo.connector.TransactionUtil;
import org.jabylon.rest.ui.model.ComplexEObjectListDataProvider;
import org.jabylon.rest.ui.model.EObjectPropertyModel;
import org.jabylon.rest.ui.wicket.BasicPanel;
import org.jabylon.rest.ui.wicket.config.AbstractConfigSection;
import org.jabylon.rest.ui.wicket.config.SettingsPage;
import org.jabylon.users.Role;
import org.jabylon.users.UserManagement;
import org.jabylon.users.UsersPackage;
import org.osgi.service.prefs.Preferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RolesConfigSection
extends BasicPanel<UserManagement> {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(RolesConfigSection.class);

    public RolesConfigSection(String id, IModel<UserManagement> model) {
        super(id, model);
        ComplexEObjectListDataProvider provider = new ComplexEObjectListDataProvider(model, (EStructuralFeature)UsersPackage.Literals.USER_MANAGEMENT__ROLES);
        ListView<Role> roleList = new ListView<Role>("role.row", provider){
            private static final long serialVersionUID = 1L;

            protected void populateItem(ListItem<Role> item) {
                EObjectPropertyModel nameProperty = new EObjectPropertyModel(item.getModel(), (EStructuralFeature)UsersPackage.Literals.ROLE__NAME);
                item.add(new Component[]{new Label("rolename", nameProperty)});
                item.add(new Component[]{new Label("roles", RolesConfigSection.this.buildRoles((Role)item.getModelObject()))});
                PageParameters params = new PageParameters(this.getPage().getPageParameters());
                params.set(params.getIndexedCount(), (Object)"roles");
                params.set(params.getIndexedCount(), (Object)((Role)item.getModelObject()).getName());
                item.add(new Component[]{new BookmarkablePageLink("edit", SettingsPage.class, params)});
                item.add(new Component[]{new Link<Role>("delete", item.getModel()){
                    private static final long serialVersionUID = 1L;

                    public void onClick() {
                        try {
                            TransactionUtil.deleteWithCrossRefs((CDOObject)((CDOObject)this.getModelObject()), (EReference[])new EReference[0]);
                        }
                        catch (CommitException e) {
                            this.getSession().error((Serializable)((Object)e.getMessage()));
                            logger.error("Failed to commit", (Throwable)e);
                        }
                    }
                }});
            }
        };
        this.add(new Component[]{roleList});
        roleList.setReuseItems(true);
        this.add(new Component[]{this.buildAddNewLink((IModel<UserManagement>)this.getModel())});
    }

    protected String buildRoles(Role modelObject) {
        return modelObject.getParent() == null ? "" : modelObject.getParent().getName();
    }

    private Component buildAddNewLink(IModel<UserManagement> model) {
        PageParameters params = new PageParameters();
        UserManagement project = (UserManagement)model.getObject();
        if (project.cdoState() == CDOState.NEW || project.cdoState() == CDOState.TRANSIENT) {
            Button link = new Button("addNew");
            link.setEnabled(false);
            return link;
        }
        params.set(0, (Object)"security");
        params.add("create", (Object)UsersPackage.Literals.ROLE.getName());
        params.add("namespace", (Object)"http://uri.jabylon.org/users");
        return new BookmarkablePageLink("addNew", SettingsPage.class, params);
    }

    public static class RolesConfigSectionContributor
    extends AbstractConfigSection<UserManagement> {
        private static final long serialVersionUID = 1L;

        @Override
        public WebMarkupContainer doCreateContents(String id, IModel<UserManagement> input, Preferences config) {
            return new RolesConfigSection(id, input);
        }

        @Override
        public void commit(IModel<UserManagement> input, Preferences config) {
        }

        @Override
        public String getRequiredPermission() {
            return "User:*:config";
        }
    }
}

