/*
 * Decompiled with CFR 0.152.
 */
package org.jabylon.rest.ui.wicket.config.sections.security;

import java.io.Serializable;
import java.security.SecureRandom;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.form.AjaxButton;
import org.apache.wicket.behavior.AttributeAppender;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.PasswordTextField;
import org.apache.wicket.markup.html.form.RequiredTextField;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.validation.IValidator;
import org.apache.wicket.validation.validator.EmailAddressValidator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.jabylon.rest.ui.model.AttachableModel;
import org.jabylon.rest.ui.model.EObjectPropertyModel;
import org.jabylon.rest.ui.wicket.BasicPanel;
import org.jabylon.rest.ui.wicket.components.ControlGroup;
import org.jabylon.rest.ui.wicket.components.UserImagePanel;
import org.jabylon.rest.ui.wicket.config.AbstractConfigSection;
import org.jabylon.rest.ui.wicket.validators.UniqueNameValidator;
import org.jabylon.security.CommonPermissions;
import org.jabylon.users.User;
import org.jabylon.users.UserManagement;
import org.jabylon.users.UsersPackage;
import org.osgi.service.prefs.Preferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserConfigSection
extends BasicPanel<User> {
    private static final long serialVersionUID = 1L;
    private TextField<String> tokenText;

    public UserConfigSection(String id, IModel<User> model, Preferences prefs) {
        super(id, model);
        boolean isLDAP = "LDAP".equals(((User)model.getObject()).getType());
        this.add(new Component[]{new UserImagePanel("image", (IModel<User>)this.getModel(), true)});
        UserManagement userManagement = this.getUserManagement();
        ControlGroup usernameGroup = new ControlGroup("username-group", (IModel<String>)this.nls("username.label", new Object[0]), (IModel<String>)this.nls("username.help.block", new Object[0]));
        RequiredTextField userID = new RequiredTextField("username", new EObjectPropertyModel(this.getModel(), (EStructuralFeature)UsersPackage.Literals.USER__NAME));
        userID.setEnabled(!isLDAP);
        if (userManagement != null) {
            userID.add((IValidator)UniqueNameValidator.fromCollection(this.getUserManagement().getUsers(), (EStructuralFeature)UsersPackage.Literals.USER__NAME, (EObject)this.getModel().getObject()));
        }
        usernameGroup.add(new Component[]{userID});
        this.add(new Component[]{usernameGroup});
        ControlGroup passwordGroup = new ControlGroup("password-group", (IModel<String>)this.nls("userpassword.label", new Object[0]), (IModel<String>)this.nls("userpassword.help.block", new Object[0]));
        PasswordTextField passwordTextField = new PasswordTextField("userpassword", new EObjectPropertyModel(this.getModel(), (EStructuralFeature)UsersPackage.Literals.USER__PASSWORD));
        passwordTextField.setRequired(!isLDAP);
        passwordTextField.setEnabled(!isLDAP);
        passwordTextField.setResetPassword(false);
        passwordGroup.add(new Component[]{passwordTextField});
        this.add(new Component[]{passwordGroup});
        ControlGroup emailGroup = new ControlGroup("email-group", (IModel<String>)this.nls("email.label", new Object[0]), (IModel<String>)this.nls("email.help.block", new Object[0]));
        TextField emailField = new TextField("email", new EObjectPropertyModel(this.getModel(), (EStructuralFeature)UsersPackage.Literals.USER__EMAIL));
        emailField.setEnabled(!isLDAP);
        emailGroup.add(new Component[]{emailField});
        emailField.add((IValidator)EmailAddressValidator.getInstance());
        this.add(new Component[]{emailGroup});
        ControlGroup displaynameGroup = new ControlGroup("displayname-group", (IModel<String>)this.nls("displayName.label", new Object[0]), (IModel<String>)this.nls("displayName.help.block", new Object[0]));
        TextField displayName = new TextField("displayName", new EObjectPropertyModel(this.getModel(), (EStructuralFeature)UsersPackage.Literals.USER__DISPLAY_NAME));
        displayName.setEnabled(!isLDAP);
        displaynameGroup.add(new Component[]{displayName});
        this.add(new Component[]{displaynameGroup});
        ControlGroup typeGroup = new ControlGroup("type-group", (IModel<String>)this.nls("login.type", new Object[0]), (IModel<String>)this.nls("type.help.block", new Object[0]));
        TextField type = new TextField("type", new EObjectPropertyModel(this.getModel(), (EStructuralFeature)UsersPackage.Literals.USER__TYPE));
        type.setEnabled(false);
        typeGroup.add(new Component[]{type});
        this.add(new Component[]{typeGroup});
        EObjectPropertyModel tokenModel = new EObjectPropertyModel(this.getModel(), (EStructuralFeature)UsersPackage.Literals.USER__TOKEN);
        ControlGroup generateTokenGroup = new ControlGroup("token-group", (IModel<String>)this.nls("token.label", new Object[0]), (IModel<String>)this.nls("token.help.block", new Object[0]));
        generateTokenGroup.add(new Behavior[]{new AttributeAppender("class", (Serializable)((Object)" input-append"))});
        this.tokenText = new TextField("token", tokenModel);
        this.tokenText.setConvertEmptyInputStringToNull(true);
        generateTokenGroup.add(new Component[]{this.tokenText});
        GenerateTokenButton generateTokenButton = new GenerateTokenButton("generate-token", false);
        generateTokenButton.setDefaultFormProcessing(false);
        generateTokenGroup.add(new Component[]{generateTokenButton});
        GenerateTokenButton deleteTokenButton = new GenerateTokenButton("delete-token", true);
        deleteTokenButton.setDefaultFormProcessing(false);
        generateTokenGroup.add(new Component[]{deleteTokenButton});
        this.add(new Component[]{generateTokenGroup});
    }

    public UserManagement getUserManagement() {
        IModel model = this.getModel();
        if (model instanceof AttachableModel) {
            AttachableModel attachable = (AttachableModel)model;
            IModel<?> parent = attachable.getParent();
            if (parent.getObject() instanceof UserManagement) {
                return (UserManagement)parent.getObject();
            }
        } else if (((User)model.getObject()).eContainer() instanceof UserManagement) {
            return (UserManagement)((User)model.getObject()).eContainer();
        }
        return null;
    }

    protected static String generateToken() {
        SecureRandom random = new SecureRandom();
        StringBuilder result = new StringBuilder();
        long number = random.nextLong();
        result.append(Long.toHexString(number));
        number = random.nextLong();
        result.append(Long.toHexString(number));
        return result.toString();
    }

    class GenerateTokenButton
    extends AjaxButton {
        private boolean delete;
        private static final long serialVersionUID = 1L;

        public GenerateTokenButton(String id, boolean delete) {
            super(id);
            this.delete = delete;
        }

        protected void onSubmit(AjaxRequestTarget target, Form<?> form) {
            super.onSubmit(target, form);
            target.add(new Component[]{UserConfigSection.this.tokenText});
            if (this.delete) {
                UserConfigSection.this.tokenText.setDefaultModelObject((Object)"");
            } else {
                UserConfigSection.this.tokenText.setDefaultModelObject((Object)UserConfigSection.generateToken());
            }
        }
    }

    public static class UserConfigSectionContributor
    extends AbstractConfigSection<User> {
        private static final long serialVersionUID = 1L;
        private static Logger logger = LoggerFactory.getLogger(UserConfigSectionContributor.class);

        @Override
        public WebMarkupContainer doCreateContents(String id, IModel<User> input, Preferences config) {
            return new UserConfigSection(id, input, config);
        }

        @Override
        public void commit(IModel<User> input, Preferences config) {
            User user = (User)input.getObject();
            if (input instanceof AttachableModel) {
                user.setType("DB");
                AttachableModel model = (AttachableModel)input;
                Object container = model.getParent().getObject();
                if (container instanceof UserManagement) {
                    UserManagement userManagement = (UserManagement)container;
                    CommonPermissions.addDefaultPermissions((UserManagement)userManagement, (User)user);
                    CommonPermissions.addDefaultPermissions((UserManagement)userManagement, (User)user);
                } else {
                    logger.error("Failed to obtain usermanagement for " + user + ". Default permissions will not be initialized");
                }
            }
        }

        @Override
        public String getRequiredPermission() {
            String name = "null";
            if (this.getDomainObject() != null && ((User)this.getDomainObject()).getName() != null) {
                name = ((User)this.getDomainObject()).getName();
            }
            return CommonPermissions.constructPermission((String[])new String[]{"User", name, "config"});
        }
    }
}

